/*
 * Decompiled with CFR 0.152.
 */
package sim8051.colourChanger;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import sim8051.colourChanger.ColourChanger;
import sim8051.colourChanger.ComponentTypes;

public class ColourChangeMenu
extends JPopupMenu {
    private ActionListener backgroundListener;
    private ActionListener foregroundListener;
    private Vector allComponents;
    private Component component;
    private int type;

    public ColourChangeMenu(Component component, Vector allComponents) {
        this.allComponents = allComponents;
        this.component = component;
        JMenuItem backgroundItem = null;
        JMenuItem foregroundItem = null;
        ComponentTypes componentTypes = new ComponentTypes();
        this.type = componentTypes.getComponentType(component);
        String[] menuItemNames = componentTypes.getColourChangeMenuItemNames(component);
        if (menuItemNames[0] != null) {
            backgroundItem = new JMenuItem(menuItemNames[0]);
        }
        if (menuItemNames[1] != null) {
            foregroundItem = new JMenuItem(menuItemNames[1]);
        }
        this.backgroundListener = new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                ColourChangeMenu.this.changeBackgroundColour();
            }
        };
        this.foregroundListener = new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                ColourChangeMenu.this.changeForegroundColour();
            }
        };
        if (backgroundItem != null) {
            this.add(backgroundItem);
            backgroundItem.addActionListener(this.backgroundListener);
        }
        if (foregroundItem != null) {
            this.add(foregroundItem);
            foregroundItem.addActionListener(this.foregroundListener);
        }
    }

    private void changeBackgroundColour() {
        ColourChanger changer = new ColourChanger(this.component, this.type, true, this.allComponents);
    }

    private void changeForegroundColour() {
        ColourChanger changer = new ColourChanger(this.component, this.type, false, this.allComponents);
    }
}

