/*
 * Decompiled with CFR 0.152.
 */
package sim8051.colourChanger;

import java.awt.Color;
import java.awt.Component;
import java.util.Vector;
import javax.swing.JColorChooser;
import javax.swing.JFrame;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import sim8051.colourChanger.ComponentTypes;

public class ColourChanger
implements ChangeListener {
    private Vector allComponents;
    private Component component;
    private boolean changeBackground;
    private JColorChooser chooser;
    private JFrame frame;
    private int type;
    private ComponentTypes componentTypes = new ComponentTypes();

    public ColourChanger(Component component, int type, boolean changeBackground, Vector allComponents) {
        this.type = type;
        this.changeBackground = changeBackground;
        this.allComponents = allComponents;
        this.chooser = changeBackground ? new JColorChooser(component.getBackground()) : new JColorChooser(component.getForeground());
        this.chooser.getSelectionModel().addChangeListener(this);
        this.frame = new JFrame();
        this.frame.add(this.chooser);
        this.frame.pack();
        this.frame.setVisible(true);
    }

    public void stateChanged(ChangeEvent e) {
        Color newColour = this.chooser.getColor();
        if (this.changeBackground) {
            this.changeBackground(newColour);
        } else {
            this.changeForeground(newColour);
        }
        this.frame.setVisible(false);
    }

    private void changeBackground(Color newColour) {
        for (int i = 0; i < this.allComponents.size(); ++i) {
            Component component = (Component)this.allComponents.elementAt(i);
            if (this.componentTypes.getComponentType(component) != this.type) continue;
            component.setBackground(newColour);
        }
    }

    private void changeForeground(Color newColour) {
        for (int i = 0; i < this.allComponents.size(); ++i) {
            Component component = (Component)this.allComponents.elementAt(i);
            if (this.componentTypes.getComponentType(component) != this.type) continue;
            component.setForeground(newColour);
        }
    }
}

