/*
 * Decompiled with CFR 0.152.
 */
package sim8051.colourChanger;

import java.awt.Component;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.JTextField;

public class ComponentTypes {
    public static final int THE_REST = 0;
    public static final int LABEL = 1;
    public static final int DATA_FIELD = 2;
    public static final int LABEL_FIELD = 3;
    public static final int ASSEMBLY_CODE_BOX = 4;
    public static final int MEMORY_WINDOW = 5;
    public static final int PORT0_LABEL = 6;
    public static final int PORT1_LABEL = 7;
    public static final int PORT2_LABEL = 8;
    public static final int PORT3_LABEL = 9;
    public static final int ADC = 10;
    public static final int UART = 11;
    public static final int UART_TX = 12;
    public static final int UART_RX = 13;
    public static final int MOTOR = 14;
    public static final int SCOPE = 15;
    public static final int SCOPE_SCREEN = 16;
    public static final int PERIPHERAL_PANEL = 17;
    public static final int MICRCONTROLLER_PANEL = 18;
    public static final int PORT_PIN_PANEL = 19;
    public static final int BUTTON = 20;
    public static final String[] TYPE_NAMES = new String[]{"THE_REST", "LABEL", "DATA_FIELD", "LABEL_FIELD", "ASSEMBLY_CODE_BOX", "MEMORY_WINDOW", "PORT0_LABEL", "PORT1_LABEL", "PORT2_LABEL", "PORT3_LABEL", "ADC", "UART", "UART_TX", "UART_RX", "MOTOR", "SCOPE", "SCOPE_SCREEN", "PERIPHERAL_PANEL", "MICRCONTROLLER_PANEL", "PORT_PIN_PANEL", "BUTTON"};

    public String[] getColourChangeMenuItemNames(Component component) {
        String[] items = new String[]{null, null};
        int type = this.getComponentType(component);
        if (type == 1 || type == 3 || type == 6 || type == 7 || type == 8 || type == 9) {
            items[1] = "Change Label Colour";
            return items;
        }
        if (type == 2) {
            items[0] = "Change Data Field Background Colour";
            items[1] = "Change Data Field Foreground Colour";
            return items;
        }
        if (type == 4 || type == 5 || type == 10 || type == 11 || type == 14 || type == 15 || type == 20 || type == 13 || type == 12) {
            items[0] = "Change Background Colour";
            items[1] = "Change Foreground Colour";
            return items;
        }
        if (type == 17 || type == 18 || type == 19) {
            items[0] = "Change Background Colour";
            return items;
        }
        return items;
    }

    public int getComponentType(Component component) {
        if (component instanceof JButton) {
            return 20;
        }
        if (component instanceof JLabel) {
            int i = this.getPortLabelNumber(component);
            if (i != -1) {
                return i;
            }
            return 1;
        }
        if (component instanceof JTextField) {
            JTextField textField = (JTextField)component;
            if (textField.isEditable()) {
                return 2;
            }
            return 3;
        }
        if (component instanceof JTextArea) {
            JTextArea textArea = (JTextArea)component;
            String toolTip = textArea.getToolTipText();
            if (toolTip == null) {
                toolTip = "";
            }
            if (textArea.isEditable()) {
                if (toolTip.equals("Data For Transmission")) {
                    return 12;
                }
                return 4;
            }
            if (toolTip.equals("Memory Window")) {
                return 5;
            }
            return 13;
        }
        if (component instanceof JPanel) {
            int panelNumber;
            JPanel panel = (JPanel)component;
            Component[] components = panel.getComponents();
            try {
                if (components.length == 4) {
                    panel = (JPanel)components[0];
                    Component[] components2 = panel.getComponents();
                    for (int i = 0; i < components2.length; ++i) {
                        panelNumber = this.getPanelNumber(components2[i]);
                        if (panelNumber == -1) continue;
                        return panelNumber;
                    }
                }
            }
            catch (Exception ex) {
                // empty catch block
            }
            for (int i = 0; i < components.length; ++i) {
                panelNumber = this.getPanelNumber(components[i]);
                if (panelNumber == -1) continue;
                return panelNumber;
            }
        }
        return 0;
    }

    private int getPanelNumber(Component component) {
        if (component instanceof JLabel) {
            JLabel label = (JLabel)component;
            String text = label.getText();
            if (text.startsWith("Copyright (c)")) {
                return 18;
            }
            if (text.equals("7-seg LED Displays")) {
                return 17;
            }
            if (text.equals("P0.7")) {
                return 19;
            }
            if (text.equals("ADC") || text.equals("Comparator")) {
                return 10;
            }
            if (text.equals("8-bit UART @")) {
                return 11;
            }
            if (text.equals("DC Motor")) {
                return 14;
            }
            if (text.equals("DAC output on scope")) {
                return 15;
            }
        }
        return -1;
    }

    private int getPortLabelNumber(Component component) {
        if (component instanceof JLabel) {
            JLabel label = (JLabel)component;
            String text = label.getText();
            if (text.startsWith("P0.") || text.startsWith("keypad ") || text.equals("display-select decoder CS/DAC WR")) {
                return 6;
            }
            if (text.startsWith("P1.") || text.startsWith("LED ")) {
                return 7;
            }
            if (text.startsWith("P2.") || text.startsWith("switch ")) {
                return 8;
            }
            if (text.startsWith("P3.") || text.equals("ADC RD/comparator output") || text.equals("ADC WR") || text.equals("motor sensor") || text.equals("display-select decoder input 1") || text.equals("dsp-select decoder i-p 0/AND o-p") || text.equals("ADC INTR") || text.startsWith("motor control bit ")) {
                return 9;
            }
        }
        return -1;
    }
}

