/*
 * Decompiled with CFR 0.152.
 */
package sim8051.colourChanger;

import java.awt.Component;
import java.awt.Container;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Vector;
import javax.swing.JPopupMenu;
import sim8051.Simulator;
import sim8051.colourChanger.ColourChangeMenu;
import sim8051.colourChanger.ComponentTypes;

public class InsertMenus {
    private Simulator sim;
    private ColourChangeMenu menu;
    private Vector allComponents = new Vector();

    public InsertMenus(Simulator sim) {
        this.sim = sim;
        this.traversePanel(sim);
        this.addMenuToComponents();
    }

    private void traversePanel(Container container) {
        Component[] components = container.getComponents();
        try {
            for (int i = 0; i < components.length; ++i) {
                this.traversePanel((Container)components[i]);
            }
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
        this.extractComponents(components);
    }

    private void extractComponents(Component[] components) {
        for (int i = 0; i < components.length; ++i) {
            this.allComponents.add(components[i]);
        }
    }

    private void addMenuToComponents() {
        ComponentTypes componentTypes = new ComponentTypes();
        for (int i = 0; i < this.allComponents.size(); ++i) {
            Component component = (Component)this.allComponents.elementAt(i);
            int type = componentTypes.getComponentType(component);
            if (type == 0) continue;
            component.addMouseListener(new MousePopupListener(new ColourChangeMenu(component, this.allComponents)));
        }
    }

    class MousePopupListener
    extends MouseAdapter {
        private JPopupMenu menu;

        MousePopupListener(JPopupMenu menu) {
            this.menu = menu;
        }

        public void mousePressed(MouseEvent e) {
            this.showPopup(e);
        }

        public void mouseReleased(MouseEvent e) {
            this.showPopup(e);
        }

        private void showPopup(MouseEvent e) {
            if (e.isPopupTrigger()) {
                this.menu.show(e.getComponent(), e.getX(), e.getY());
            }
        }
    }
}

