/*
 * Decompiled with CFR 0.152.
 */
package sim8051.lcd;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import javax.swing.BorderFactory;
import javax.swing.JPanel;

public class Character
extends JPanel {
    private int dotSize;
    private int numberOfRows = 8;
    private int numberOfColumns = 5;
    private boolean[][] dots = new boolean[this.numberOfRows][this.numberOfColumns];
    private long[] rom;
    private char[] ram;
    private int address;
    private boolean blank = false;
    private boolean cursorOn = false;
    private boolean blinking = false;
    private boolean blinkInOnState;
    private int ddRamAddress = 0;

    public Character(boolean small, int address, long[] rom, char[] ram) {
        this.address = address;
        this.rom = rom;
        this.ram = ram;
        this.setBorder(BorderFactory.createLineBorder(Color.WHITE, 1));
        this.setSmall(small);
        this.displayCharacter(false, false, true, 0);
    }

    public void setSmall(boolean small) {
        this.dotSize = small ? 2 : 3;
        Dimension d = new Dimension(this.numberOfColumns * this.dotSize + 3, this.numberOfRows * this.dotSize + 3);
        this.setMinimumSize(d);
        this.setMaximumSize(d);
        this.setPreferredSize(d);
    }

    public void setBlank(boolean b) {
        this.blank = b;
    }

    public void setAddress(int address) {
        this.address = address;
    }

    public int getAddress() {
        return this.address;
    }

    public void shiftLeft() {
        ++this.address;
        if (this.address > 39 && this.address < 64) {
            this.address = 0;
        } else if (this.address > 103) {
            this.address = 64;
        }
    }

    public void shiftRight() {
        --this.address;
        if (this.address < 0) {
            this.address = 39;
        } else if (this.address < 64 && this.address > 39) {
            this.address = 103;
        }
    }

    public void displayCharacter(boolean cursorOn, boolean blinking, boolean blinkInOnState, int ddRamAddress) {
        this.cursorOn = cursorOn;
        this.blinking = blinking;
        this.blinkInOnState = blinkInOnState;
        this.ddRamAddress = ddRamAddress;
        char asciiValue = this.ram[this.address];
        long romValue = this.rom[asciiValue];
        String s = Long.toBinaryString(romValue);
        while (s.length() < 40) {
            s = "0" + s;
        }
        int index = 0;
        for (int i = 0; i < this.numberOfRows; ++i) {
            for (int j = 0; j < this.numberOfColumns; ++j) {
                this.dots[i][j] = s.charAt(index) == '1';
                ++index;
            }
        }
        this.repaint();
    }

    public void paintComponent(Graphics g) {
        Color dotColor = Color.BLACK;
        Color backgroundColor = Color.GRAY;
        if (this.blinking && this.address == this.ddRamAddress) {
            if (this.blinkInOnState) {
                dotColor = Color.BLUE;
                backgroundColor = Color.RED;
            } else {
                dotColor = Color.RED;
                backgroundColor = Color.BLUE;
            }
        }
        for (int i = 0; i < this.numberOfRows; ++i) {
            for (int j = 0; j < this.numberOfColumns; ++j) {
                this.paintDot(g, i, j, dotColor, backgroundColor);
            }
        }
        if (this.cursorOn && this.address == this.ddRamAddress) {
            g.setColor(dotColor);
            for (int j = 0; j < this.numberOfColumns; ++j) {
                g.fillRect(j * this.dotSize + this.dotSize, 7 * this.dotSize + this.dotSize, this.dotSize, this.dotSize);
            }
        }
    }

    private void paintDot(Graphics g, int row, int column, Color dotColor, Color backgroundColor) {
        if (!this.blank && this.dots[row][column]) {
            g.setColor(dotColor);
        } else {
            g.setColor(backgroundColor);
        }
        g.fillRect(column * this.dotSize + this.dotSize, row * this.dotSize + this.dotSize, this.dotSize, this.dotSize);
    }
}

