/*
 * Decompiled with CFR 0.152.
 */
package sim8051.lcd;

import sim8051.lcd.CharacterStrings;
import sim8051.lcd.LcdModuleGraphics;

public class LcdModule {
    private final int EIGHT_BIT_MODE = 0;
    private final int INTER_MODE = 1;
    private final int FOUR_BIT_MODE = 2;
    private final int ERROR = 3;
    private final int BLINK_INTERVAL = 189600;
    private int mode = 0;
    private LcdModuleGraphics lcdModuleGraphics;
    private long[] rom;
    private char[] ddRam = new char[104];
    private int bf = 0;
    private boolean highNibble = true;
    private boolean e;
    private boolean previousE = false;
    private boolean rs;
    private boolean r_w = false;
    private int dataBusIn;
    private int ir;
    private int dr;
    private int ddRamAddress = 0;
    private int cgRamAddress = 0;
    private boolean pointingToDdRam = true;
    private boolean increment = true;
    private boolean shift = false;
    private boolean displayOn = false;
    private boolean cursorOn = false;
    private boolean blinking = false;
    private boolean blinkInOnState = true;
    private int blinkCount = 0;
    private boolean timeToRefresh = false;

    public LcdModule(boolean size) {
        this.clearDdRam();
        this.rom = new CharacterStrings(true).getRom();
        this.lcdModuleGraphics = new LcdModuleGraphics(size, this.rom, this.ddRam);
    }

    private int convertCgRamAddress(int address) {
        int row = address & 7;
        row = 7 - row;
        return (address &= 0x38) + row;
    }

    public void updateCgRam(int address, long data) {
        address = this.convertCgRamAddress(address);
        data &= 0x1FL;
        int characterAddress = address >> 3;
        int rowAddress = address & 7;
        data <<= rowAddress * 5;
        long character = this.rom[characterAddress];
        long newCharacter = 0L;
        long mask = 31L;
        for (int i = 0; i < 8; ++i) {
            newCharacter = i == rowAddress ? (newCharacter += data) : (newCharacter += character & mask);
            mask <<= 5;
        }
        this.rom[characterAddress] = newCharacter;
        this.rom[characterAddress + 8] = newCharacter;
    }

    public LcdModuleGraphics getModuleGraphics() {
        return this.lcdModuleGraphics;
    }

    public void refreshDisplay() {
        if (this.timeToRefresh) {
            this.lcdModuleGraphics.refreshDisplay(this.cursorOn, this.blinking, this.blinkInOnState, this.ddRamAddress);
            this.timeToRefresh = false;
        }
        int ac = this.pointingToDdRam ? this.ddRamAddress : this.cgRamAddress;
        this.lcdModuleGraphics.updateTextFields(this.bf, ac, this.ir, this.dr);
    }

    public void setDataBus(int data) {
        this.dataBusIn = data >> 4;
    }

    public void setE(int i) {
        this.e = i == 1;
    }

    public void setRs(int i) {
        this.rs = i == 1;
    }

    public void reset() {
        this.mode = 0;
        this.clearDisplay();
        this.displayOn = false;
        this.cursorOn = false;
        this.blinking = false;
        this.increment = true;
        this.shift = false;
        this.bf = 0;
        this.ir = 0;
        this.dr = 0;
        this.ddRamAddress = 0;
        this.cgRamAddress = 0;
        this.lcdModuleGraphics.unShift();
        this.lcdModuleGraphics.turnOffDisplay();
        this.lcdModuleGraphics.refreshDisplay(this.cursorOn, this.blinking, this.blinkInOnState, this.ddRamAddress);
        this.lcdModuleGraphics.updateTextFields(0, 0, 0, 0);
        this.lcdModuleGraphics.clearErrorMessage();
    }

    public void cycle() {
        if (this.mode == 3) {
            return;
        }
        if (this.blinking) {
            ++this.blinkCount;
            if (this.blinkCount == 189600) {
                this.blinkCount = 0;
                this.blinkInOnState = !this.blinkInOnState;
                this.timeToRefresh = true;
            }
        }
        if (this.bf > 0) {
            --this.bf;
            if (this.bf == 0) {
                this.timeToRefresh = true;
            }
        }
        if (this.mode == 0) {
            this.eightBitCycle();
        } else {
            this.fourBitCycle();
        }
    }

    private boolean isBfRead() {
        return false;
    }

    private void eightBitCycle() {
        if (this.previousE && !this.e && !this.isBfRead() && this.bf == 0) {
            this.ir = this.dataBusIn;
            if (this.ir == 2) {
                this.mode = 1;
                this.bf = 37;
            } else {
                this.mode = 3;
                this.lcdModuleGraphics.setErrorMessage(1, 0, 0);
            }
        }
        this.previousE = this.e;
    }

    private void fourBitCycle() {
        if (this.previousE && !this.e && !this.isBfRead() && this.bf == 0 && !this.r_w) {
            this.write();
        }
        this.previousE = this.e;
    }

    private void write() {
        if (!this.rs) {
            if (this.highNibble) {
                this.ir = this.dataBusIn << 4;
                this.highNibble = false;
            } else {
                this.ir += this.dataBusIn;
                this.highNibble = true;
                this.execute();
            }
        } else if (this.highNibble) {
            this.dr = this.dataBusIn << 4;
            this.highNibble = false;
        } else {
            this.bf = 37;
            this.dr += this.dataBusIn;
            if (this.pointingToDdRam) {
                this.ddRam[this.ddRamAddress] = (char)(this.dr & 0x7F);
                this.incDecDdRamAddress(this.increment);
                this.shiftDisplayAfterDdRamWrite();
            } else {
                this.updateCgRam(this.cgRamAddress, this.dr & 0x3F);
                this.incDecCgRamAddress(this.increment);
            }
            this.highNibble = true;
        }
    }

    private void execute() {
        this.bf = 37;
        if (this.mode == 1 && this.ir >> 5 == 1) {
            this.functionSet();
            return;
        }
        if (this.ir == 1) {
            this.clearDisplay();
            this.bf = 1520;
        } else if (this.ir == 2 || this.ir == 3) {
            this.returnHome();
            this.bf = 1520;
        } else if (this.ir > 3 && this.ir <= 7) {
            this.entryModeSet();
        } else if (this.ir <= 15) {
            this.displayOnOffControl();
        } else if (this.ir <= 31) {
            this.cursorOrDisplayShift();
        } else if (this.ir <= 127) {
            this.setCgRamAddress();
        } else if (this.ir <= 255) {
            this.setDdRamAddress();
        }
    }

    private void setDdRamAddress() {
        this.pointingToDdRam = true;
        int address = this.ir & 0x7F;
        if (address > 39 && address < 64) {
            address = address - 40 + 64;
        } else if (address > 103) {
            address -= 104;
        }
        this.ddRamAddress = address;
    }

    private void setCgRamAddress() {
        this.pointingToDdRam = false;
        this.cgRamAddress = this.ir & 0x3F;
    }

    private void functionSet() {
        boolean fourBit;
        int f = this.ir >> 2 & 1;
        boolean correctFont = f == 0;
        int n = this.ir >> 3 & 1;
        boolean twoLines = n == 1;
        int dl = this.ir >> 4 & 1;
        boolean bl = fourBit = dl == 0;
        if (correctFont && twoLines && fourBit) {
            this.mode = 2;
        } else {
            this.mode = 3;
            this.lcdModuleGraphics.setErrorMessage(dl, n, f);
        }
    }

    private void cursorOrDisplayShift() {
        boolean shift;
        int i = this.ir >> 2;
        boolean right = (i & 1) == 1;
        boolean bl = shift = ((i >>= 1) & 1) == 1;
        if (shift) {
            if (right) {
                this.lcdModuleGraphics.shiftRight();
            } else {
                this.lcdModuleGraphics.shiftLeft();
            }
        } else {
            this.pointingToDdRam = true;
            if (right) {
                this.incDecDdRamAddress(true);
            } else {
                this.incDecDdRamAddress(false);
            }
        }
    }

    private void displayOnOffControl() {
        int i = this.ir;
        this.blinking = (i & 1) == 1;
        this.cursorOn = ((i >>= 1) & 1) == 1;
        boolean bl = this.displayOn = ((i >>= 1) & 1) == 1;
        if (this.displayOn) {
            this.lcdModuleGraphics.turnOnDisplay();
        } else {
            this.lcdModuleGraphics.turnOffDisplay();
        }
    }

    private void entryModeSet() {
        int i = this.ir;
        this.shift = (i & 1) == 1;
        this.increment = ((i >>= 1) & 1) == 1;
    }

    private void returnHome() {
        this.ddRamAddress = 0;
        this.lcdModuleGraphics.unShift();
    }

    private void clearDisplay() {
        this.clearDdRam();
        this.ddRamAddress = 0;
        this.pointingToDdRam = true;
        this.increment = true;
        this.lcdModuleGraphics.unShift();
    }

    private void clearDdRam() {
        for (int i = 0; i < this.ddRam.length; ++i) {
            this.ddRam[i] = 32;
        }
    }

    private void shiftDisplayAfterDdRamWrite() {
        if (this.shift) {
            if (this.increment) {
                this.lcdModuleGraphics.shiftLeftIfRequired(this.ddRamAddress);
            } else {
                this.lcdModuleGraphics.shiftRightIfRequired(this.ddRamAddress);
            }
        }
    }

    private void incDecDdRamAddress(boolean increment) {
        if (increment) {
            ++this.ddRamAddress;
            if (this.ddRamAddress > 103) {
                this.ddRamAddress = 0;
            } else if (this.ddRamAddress > 39 && this.ddRamAddress < 64) {
                this.ddRamAddress = 64;
            }
        } else {
            --this.ddRamAddress;
            if (this.ddRamAddress < 0) {
                this.ddRamAddress = 103;
            } else if (this.ddRamAddress < 64 && this.ddRamAddress > 39) {
                this.ddRamAddress = 39;
            }
        }
    }

    private void incDecCgRamAddress(boolean increment) {
        if (increment) {
            ++this.cgRamAddress;
            if (this.cgRamAddress > 63) {
                this.cgRamAddress = 0;
            }
        } else {
            --this.cgRamAddress;
            if (this.cgRamAddress < 0) {
                this.cgRamAddress = 63;
            }
        }
    }
}

