/*
 * Decompiled with CFR 0.152.
 */
package sim8051.lcd;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import sim8051.Sizes;
import sim8051.Text;
import sim8051.lcd.Character;

public class LcdModuleGraphics
extends JPanel {
    private Character[] topCharacters = new Character[16];
    private Character[] bottomCharacters = new Character[16];
    private Sizes sizes = new Sizes();
    private Font errorMessageSmallFont = new Font("Arial", 0, 12);
    private Font errorMessageLargeFont = new Font("Arial", 0, 18);
    private JLabel acLabel;
    private JTextField acTextField;
    private JLabel bfLabel;
    private JTextField bfTextField;
    private JPanel bottomPanel;
    private JLabel drLabel;
    private JTextField drTextField;
    private JTextArea errorMessageTextArea;
    private JLabel irLabel;
    private JTextField irTextField;
    private JPanel topPanel;

    public LcdModuleGraphics(boolean small, long[] rom, char[] ram) {
        GridBagConstraints gbc;
        int i;
        this.initComponents();
        this.errorMessageTextArea.setVisible(false);
        for (i = 0; i < this.topCharacters.length; ++i) {
            this.topCharacters[i] = new Character(small, i, rom, ram);
            gbc = new GridBagConstraints();
            gbc.gridx = i;
            gbc.gridy = 0;
            this.topPanel.add((Component)this.topCharacters[i], gbc);
        }
        for (i = 0; i < this.bottomCharacters.length; ++i) {
            this.bottomCharacters[i] = new Character(small, i + 64, rom, ram);
            gbc = new GridBagConstraints();
            gbc.gridx = i;
            gbc.gridy = 1;
            this.topPanel.add((Component)this.bottomCharacters[i], gbc);
        }
        this.setSmall(small);
    }

    public void clearErrorMessage() {
        this.errorMessageTextArea.setVisible(false);
        this.topPanel.setVisible(true);
        this.bottomPanel.setVisible(true);
    }

    public void setErrorMessage(int dl, int n, int f) {
        this.errorMessageTextArea.setText("Error! Function set incorrect.\nDL=" + dl + " N=" + n + " F=" + f + "\nFunction set must be DL=0 N=1 F=0.");
        this.topPanel.setVisible(false);
        this.bottomPanel.setVisible(false);
        this.errorMessageTextArea.setVisible(true);
    }

    public void setSmall(boolean small) {
        int i;
        int borderWidth;
        Dimension otherDimension;
        Dimension bfDimension;
        Font bfFont;
        if (small) {
            bfFont = new Font("Arial", 0, 10);
            bfDimension = new Dimension(this.sizes.microEightBitFieldSmall.width * 2 / 3, this.sizes.microEightBitFieldSmall.height);
            otherDimension = new Dimension(this.sizes.microEightBitFieldSmall.width * 6 / 7, this.sizes.microEightBitFieldSmall.height);
            borderWidth = 1;
            this.bfLabel.setFont(this.sizes.fontBoldSmall);
            this.acLabel.setFont(this.sizes.fontBoldSmall);
            this.irLabel.setFont(this.sizes.fontBoldSmall);
            this.drLabel.setFont(this.sizes.fontBoldSmall);
            this.bfTextField.setPreferredSize(bfDimension);
            this.bfTextField.setMaximumSize(bfDimension);
            this.bfTextField.setMinimumSize(bfDimension);
            this.acTextField.setPreferredSize(otherDimension);
            this.acTextField.setMaximumSize(otherDimension);
            this.acTextField.setMinimumSize(otherDimension);
            this.irTextField.setPreferredSize(otherDimension);
            this.irTextField.setMaximumSize(otherDimension);
            this.irTextField.setMinimumSize(otherDimension);
            this.drTextField.setPreferredSize(otherDimension);
            this.drTextField.setMaximumSize(otherDimension);
            this.drTextField.setMinimumSize(otherDimension);
            this.bfTextField.setFont(bfFont);
            this.acTextField.setFont(this.sizes.fontSmall);
            this.irTextField.setFont(this.sizes.fontSmall);
            this.drTextField.setFont(this.sizes.fontSmall);
            this.errorMessageTextArea.setFont(this.errorMessageSmallFont);
        } else {
            bfFont = new Font("Arial", 0, 15);
            bfDimension = new Dimension(this.sizes.microEightBitFieldLarge.width * 2 / 3, this.sizes.microEightBitFieldLarge.height);
            otherDimension = new Dimension(this.sizes.microEightBitFieldLarge.width * 6 / 7, this.sizes.microEightBitFieldLarge.height);
            borderWidth = 3;
            this.bfLabel.setFont(this.sizes.fontBoldLarge);
            this.acLabel.setFont(this.sizes.fontBoldLarge);
            this.irLabel.setFont(this.sizes.fontBoldLarge);
            this.drLabel.setFont(this.sizes.fontBoldLarge);
            this.bfTextField.setPreferredSize(bfDimension);
            this.bfTextField.setMaximumSize(bfDimension);
            this.bfTextField.setMinimumSize(bfDimension);
            this.acTextField.setPreferredSize(otherDimension);
            this.acTextField.setMaximumSize(otherDimension);
            this.acTextField.setMinimumSize(otherDimension);
            this.irTextField.setPreferredSize(otherDimension);
            this.irTextField.setMaximumSize(otherDimension);
            this.irTextField.setMinimumSize(otherDimension);
            this.drTextField.setPreferredSize(otherDimension);
            this.drTextField.setMaximumSize(otherDimension);
            this.drTextField.setMinimumSize(otherDimension);
            this.bfTextField.setFont(bfFont);
            this.acTextField.setFont(this.sizes.fontLarge);
            this.irTextField.setFont(this.sizes.fontLarge);
            this.drTextField.setFont(this.sizes.fontLarge);
            this.errorMessageTextArea.setFont(this.errorMessageLargeFont);
        }
        this.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createLineBorder(new Color(0, 0, 0), borderWidth), BorderFactory.createBevelBorder(1, null, new Color(255, 255, 255), null, null)));
        for (i = 0; i < this.topCharacters.length; ++i) {
            this.topCharacters[i].setSmall(small);
        }
        for (i = 0; i < this.bottomCharacters.length; ++i) {
            this.bottomCharacters[i].setSmall(small);
        }
    }

    public void turnOnDisplay() {
        this.turnOnOffDisplay(false);
    }

    public void turnOffDisplay() {
        this.turnOnOffDisplay(true);
    }

    private void turnOnOffDisplay(boolean off) {
        int i;
        for (i = 0; i < this.topCharacters.length; ++i) {
            this.topCharacters[i].setBlank(off);
        }
        for (i = 0; i < this.bottomCharacters.length; ++i) {
            this.bottomCharacters[i].setBlank(off);
        }
    }

    public void unShift() {
        int i;
        for (i = 0; i < this.topCharacters.length; ++i) {
            this.topCharacters[i].setAddress(i);
        }
        for (i = 0; i < this.bottomCharacters.length; ++i) {
            this.bottomCharacters[i].setAddress(64 + i);
        }
    }

    private boolean isRamLocationBeingDisplayed(int ramAddress) {
        int i;
        for (i = 0; i < this.topCharacters.length; ++i) {
            if (this.topCharacters[i].getAddress() != ramAddress) continue;
            return true;
        }
        for (i = 0; i < this.bottomCharacters.length; ++i) {
            if (this.bottomCharacters[i].getAddress() != ramAddress) continue;
            return true;
        }
        return false;
    }

    public void shiftLeftIfRequired(int ramAddress) {
        if (!this.isRamLocationBeingDisplayed(ramAddress)) {
            this.shiftLeft();
        }
    }

    public void shiftRightIfRequired(int ramAddress) {
        if (!this.isRamLocationBeingDisplayed(ramAddress)) {
            this.shiftRight();
        }
    }

    public void shiftLeft() {
        int i;
        for (i = 0; i < this.topCharacters.length; ++i) {
            this.topCharacters[i].shiftLeft();
        }
        for (i = 0; i < this.bottomCharacters.length; ++i) {
            this.bottomCharacters[i].shiftLeft();
        }
    }

    public void shiftRight() {
        int i;
        for (i = 0; i < this.topCharacters.length; ++i) {
            this.topCharacters[i].shiftRight();
        }
        for (i = 0; i < this.bottomCharacters.length; ++i) {
            this.bottomCharacters[i].shiftRight();
        }
    }

    public void refreshDisplay(boolean cursorOn, boolean blinking, boolean blinkInOnState, int ddRamAddress) {
        int i;
        for (i = 0; i < this.topCharacters.length; ++i) {
            this.topCharacters[i].displayCharacter(cursorOn, blinking, blinkInOnState, ddRamAddress);
        }
        for (i = 0; i < this.bottomCharacters.length; ++i) {
            this.bottomCharacters[i].displayCharacter(cursorOn, blinking, blinkInOnState, ddRamAddress);
        }
    }

    public void updateTextFields(int bf, int ac, int ir, int dr) {
        this.bfTextField.setText(String.valueOf(bf));
        this.acTextField.setText(Text.inHex(ac, true));
        this.irTextField.setText(Text.inHex(ir, true));
        this.drTextField.setText(Text.inHex(dr, true));
    }

    private void initComponents() {
        this.topPanel = new JPanel();
        this.bottomPanel = new JPanel();
        this.bfLabel = new JLabel();
        this.acLabel = new JLabel();
        this.irLabel = new JLabel();
        this.drLabel = new JLabel();
        this.bfTextField = new JTextField();
        this.acTextField = new JTextField();
        this.irTextField = new JTextField();
        this.drTextField = new JTextField();
        this.errorMessageTextArea = new JTextArea();
        this.setLayout(new GridBagLayout());
        this.setBackground(new Color(255, 255, 255));
        this.topPanel.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        this.add((Component)this.topPanel, gridBagConstraints);
        this.bottomPanel.setLayout(new GridBagLayout());
        this.bottomPanel.setBackground(new Color(255, 255, 255));
        this.bfLabel.setText("BF");
        this.bfLabel.setToolTipText("Busy Flag");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(0, 0, 0, 2);
        this.bottomPanel.add((Component)this.bfLabel, gridBagConstraints);
        this.acLabel.setText("AC");
        this.acLabel.setToolTipText("Address Counter");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(0, 0, 0, 2);
        this.bottomPanel.add((Component)this.acLabel, gridBagConstraints);
        this.irLabel.setText("IR");
        this.irLabel.setToolTipText("Instruction Register");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(0, 0, 0, 2);
        this.bottomPanel.add((Component)this.irLabel, gridBagConstraints);
        this.drLabel.setText("DR");
        this.drLabel.setToolTipText("Data Register");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 6;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(0, 0, 0, 2);
        this.bottomPanel.add((Component)this.drLabel, gridBagConstraints);
        this.bfTextField.setEditable(false);
        this.bfTextField.setHorizontalAlignment(4);
        this.bfTextField.setToolTipText("Time (in microseconds) before BF is clear");
        this.bfTextField.setBorder(BorderFactory.createLineBorder(new Color(0, 0, 0)));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(0, 0, 0, 7);
        this.bottomPanel.add((Component)this.bfTextField, gridBagConstraints);
        this.acTextField.setEditable(false);
        this.acTextField.setHorizontalAlignment(4);
        this.acTextField.setBorder(BorderFactory.createLineBorder(new Color(0, 0, 0)));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(0, 0, 0, 7);
        this.bottomPanel.add((Component)this.acTextField, gridBagConstraints);
        this.irTextField.setEditable(false);
        this.irTextField.setHorizontalAlignment(4);
        this.irTextField.setBorder(BorderFactory.createLineBorder(new Color(0, 0, 0)));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 5;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(0, 0, 0, 7);
        this.bottomPanel.add((Component)this.irTextField, gridBagConstraints);
        this.drTextField.setEditable(false);
        this.drTextField.setHorizontalAlignment(4);
        this.drTextField.setBorder(BorderFactory.createLineBorder(new Color(0, 0, 0)));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 7;
        gridBagConstraints.gridy = 0;
        this.bottomPanel.add((Component)this.drTextField, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        this.add((Component)this.bottomPanel, gridBagConstraints);
        this.errorMessageTextArea.setColumns(20);
        this.errorMessageTextArea.setEditable(false);
        this.errorMessageTextArea.setFont(new Font("Monospaced", 0, 12));
        this.errorMessageTextArea.setForeground(new Color(255, 0, 0));
        this.errorMessageTextArea.setRows(5);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        this.add((Component)this.errorMessageTextArea, gridBagConstraints);
    }
}

