/*
 * Decompiled with CFR 0.152.
 */
package sim8051.peripherals;

import javax.swing.JSlider;

public class ADC {
    private boolean enabled = true;
    private JSlider slider;
    private boolean rd = true;
    private boolean wr = true;
    private boolean intr = true;
    private boolean[] internalBits = new boolean[8];
    private int analogueInput = 0;
    private int conversionState;
    private boolean converting = false;

    public ADC(JSlider slider) {
        this.slider = slider;
        this.reset();
    }

    public void enableAdc() {
        this.enabled = true;
    }

    public void disableAdc() {
        this.enabled = false;
    }

    public boolean isPinHigh(int pinNumber) {
        if (!this.enabled || this.rd || pinNumber < 0 || pinNumber > 7) {
            return true;
        }
        return this.internalBits[pinNumber];
    }

    public void setRd() {
        this.rd = true;
    }

    public void clearRd() {
        this.rd = false;
    }

    public void setWr() {
        this.wr = true;
    }

    public void clearWr() {
        if (this.wr) {
            this.startConversion();
        }
        this.wr = false;
    }

    public boolean getIntr() {
        return this.intr;
    }

    public void convert() {
        if (this.converting) {
            this.internalBits[this.conversionState] = (this.analogueInput >> this.conversionState & 1) == 1;
            --this.conversionState;
            if (this.conversionState < 0) {
                this.conversionState = 7;
                this.intr = false;
                this.converting = false;
            }
        }
    }

    public void reset() {
        this.intr = true;
        this.conversionState = 7;
        this.converting = false;
        for (int i = 0; i < 8; ++i) {
            this.internalBits[i] = true;
        }
    }

    private void startConversion() {
        this.reset();
        this.analogueInput = this.slider.getValue();
        this.converting = true;
    }
}

