/*
 * Decompiled with CFR 0.152.
 */
package sim8051.peripherals;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import javax.swing.JPanel;
import sim8051.Sizes;

public class DAC
extends JPanel {
    private boolean inputsEnabled = false;
    private Color traceColor;
    private int numberOfRows;
    private int numberOfCols;
    private int currentCol = 0;
    private int scale;
    private int[] pixelPositions;
    private int data = 0;
    private Sizes sizes = new Sizes();
    private boolean pause = false;

    public DAC(Color backgroundColor, Color traceColor, boolean small) {
        this.setScale(small);
        this.setBackground(backgroundColor);
        this.traceColor = traceColor;
        this.pixelPositions = new int[this.numberOfCols];
        this.resetTrace();
    }

    public void setScale(boolean small) {
        Dimension d;
        this.pause = true;
        if (small) {
            d = this.sizes.scopePanelSmall;
            this.scale = 3;
        } else {
            d = this.sizes.scopePanelLarge;
            this.scale = 5;
        }
        this.setMaximumSize(d);
        this.setMinimumSize(d);
        this.setPreferredSize(d);
        this.numberOfCols = (int)d.getWidth();
        this.numberOfRows = (int)d.getHeight() - this.scale * 2;
        this.pixelPositions = new int[this.numberOfCols];
        this.resetTrace();
        this.pause = false;
    }

    private void resetTrace() {
        for (int i = 0; i < this.numberOfCols; ++i) {
            this.pixelPositions[i] = this.numberOfRows;
        }
    }

    public void enableInputs() {
        this.inputsEnabled = true;
    }

    public void disableInputs() {
        this.inputsEnabled = false;
    }

    public void incrementTime() {
        ++this.currentCol;
        if (this.currentCol >= this.numberOfCols) {
            this.currentCol = 0;
        }
        this.pixelPositions[this.currentCol] = this.dataToRowNumber();
    }

    public int getData() {
        return this.data;
    }

    public void latchData(int data) {
        if (this.inputsEnabled) {
            this.data = data;
        }
    }

    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        g.setColor(this.traceColor);
        if (!this.pause) {
            for (int i = 0; i < this.numberOfCols; ++i) {
                g.drawLine(i, this.pixelPositions[i] + this.scale, i, this.pixelPositions[i] + this.scale);
                if (this.scale != 5) continue;
                g.drawLine(i + 1, this.pixelPositions[i] + this.scale + 1, i + 1, this.pixelPositions[i] + this.scale + 1);
            }
        }
    }

    private int dataToRowNumber() {
        return (int)((float)this.numberOfRows - (float)this.data / (256.0f / (float)this.numberOfRows));
    }
}

