/*
 * Decompiled with CFR 0.152.
 */
package sim8051.peripherals;

import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.JTextArea;

public class ExternalUart {
    private double systemFreq = 12.0;
    private int baud = 19200;
    private int bitRateInMachineCycles;
    private int rxData = 0;
    private boolean receiving = false;
    private int rxLine = 1;
    private int prevRxLine = 1;
    private int rxBit = 0;
    private int rxClock;
    private JTextArea rxDataField;
    private int txData = 0;
    private int txLine = 1;
    private int txBit = -1;
    private int txClock;
    private String dataToTx = "";
    private Vector hexData = null;
    private JTextArea txDataField;
    private int parity = 0;

    public ExternalUart(JTextArea rxDataField, JTextArea txDataField, double systemFreq) {
        this.rxDataField = rxDataField;
        this.txDataField = txDataField;
        this.systemFreq = systemFreq;
        this.setBitRateInMachineCycles();
        this.rxClock = this.bitRateInMachineCycles;
        this.txClock = this.bitRateInMachineCycles;
    }

    public void setSystemFreq(double systemFreq) {
        this.systemFreq = systemFreq;
        this.setBitRateInMachineCycles();
        this.resetReceiver();
        this.resetTransmitter();
    }

    public void setBaudRate(String sBaud) {
        sBaud = sBaud.substring(0, sBaud.indexOf(32));
        this.baud = Integer.parseInt(sBaud);
        this.setBitRateInMachineCycles();
        this.rxClock = this.bitRateInMachineCycles;
        this.txClock = this.bitRateInMachineCycles;
        this.resetReceiver();
        this.resetTransmitter();
    }

    public void setParity(int parity) {
        this.parity = parity;
    }

    public String changeParity() {
        ++this.parity;
        if (this.parity == 3) {
            this.parity = 0;
        }
        this.resetReceiver();
        this.resetTransmitter();
        return this.getParityString();
    }

    public boolean isEvenParity() {
        return this.parity == 2;
    }

    public boolean isOddParity() {
        return this.parity == 1;
    }

    public boolean isNoParity() {
        return this.parity == 0;
    }

    public String getParityString() {
        if (this.parity == 0) {
            return "No Parity";
        }
        if (this.parity == 1) {
            return "Odd Parity";
        }
        return "Even Parity";
    }

    public int getParity() {
        return this.parity;
    }

    public void pulseClock() {
        --this.rxClock;
        if (this.rxClock <= 0) {
            this.rxClock = this.bitRateInMachineCycles;
            if (this.receiving) {
                this.receiveBit();
            } else if (this.prevRxLine == 1 && this.rxLine == 0) {
                this.receiving = true;
            }
            this.prevRxLine = this.rxLine;
        }
        --this.txClock;
        if (this.txClock <= 0) {
            this.txClock = this.bitRateInMachineCycles;
            if (this.dataToTx.length() > 0 || this.hexData != null) {
                this.transmitBit();
            }
        }
    }

    public void updateRxLine(boolean bit) {
        this.rxLine = bit ? 1 : 0;
    }

    public void resetReceiver() {
        this.receiving = false;
        this.rxBit = 0;
        this.rxDataField.setText("");
        this.rxLine = 1;
        this.prevRxLine = 1;
    }

    public boolean isTxLineHigh() {
        return this.txLine == 1;
    }

    public void startTransmission() {
        this.dataToTx = this.txDataField.getText();
        if (this.isEscapedAscii(this.dataToTx)) {
            this.dataToTx = this.dataToTx.substring(1) + "\r";
        } else {
            this.hexData = this.txDataToHex(this.dataToTx);
            this.dataToTx = this.hexData == null ? this.dataToTx + "\r" : "";
        }
    }

    private boolean isEscapedAscii(String data) {
        if (data.charAt(0) != '\\') {
            return false;
        }
        String s = data;
        while (s.length() > 0 && s.charAt(0) == '\\') {
            s = s.substring(1);
        }
        if (s.length() == 0) {
            return false;
        }
        Vector v = this.txDataToHex(s);
        return v != null;
    }

    private Vector txDataToHex(String data) {
        if (data.charAt(0) != '{' && data.charAt(data.length() - 1) != '}') {
            return null;
        }
        Vector<Integer> v = new Vector<Integer>();
        data = data.substring(1, data.length() - 1);
        StringTokenizer st = new StringTokenizer(data, ",");
        int count = st.countTokens();
        for (int i = 0; i < count; ++i) {
            try {
                String s = st.nextToken().trim();
                int h = Integer.parseInt(s, 16) & 0xFF;
                v.addElement(new Integer(h));
                continue;
            }
            catch (NumberFormatException ex) {
                return null;
            }
        }
        return v;
    }

    public void resetTransmitter() {
        this.dataToTx = "";
        this.hexData = null;
        this.txBit = -1;
        this.txLine = 1;
    }

    private void receiveBit() {
        if (this.rxBit == 8) {
            this.rxBit = 0;
            if (this.isValidByte(this.rxData)) {
                this.rxDataField.setText(this.rxDataField.getText() + String.valueOf((char)this.clearMsb(this.rxData)));
            }
            this.rxData = 0;
            this.receiving = false;
        } else {
            this.rxData += this.rxLine << this.rxBit;
            ++this.rxBit;
        }
    }

    private void transmitBit() {
        if (this.hexData != null) {
            this.transmitHexBit();
        } else if (this.txBit == -1) {
            this.txLine = 0;
            ++this.txBit;
        } else if (this.txBit == 8) {
            this.txLine = 1;
            this.txBit = -1;
            this.dataToTx = this.dataToTx.length() > 1 ? this.dataToTx.substring(1) : "";
            this.txDataField.setText(this.dataToTx);
        } else {
            this.txData = this.dataToTx.charAt(0);
            this.txData = this.addParityBit(this.txData);
            this.txLine = this.txData >> this.txBit & 1;
            ++this.txBit;
        }
    }

    private void transmitHexBit() {
        if (this.txBit == -1) {
            this.txLine = 0;
            ++this.txBit;
        } else if (this.txBit == 8) {
            this.txLine = 1;
            this.txBit = -1;
            if (this.hexData.size() > 1) {
                this.hexData.removeElementAt(0);
                this.txDataField.setText(this.hexDataToString());
            } else {
                this.hexData = null;
                this.txDataField.setText("");
            }
        } else {
            this.txData = (Integer)this.hexData.elementAt(0);
            this.txData = this.addParityBit(this.txData);
            this.txLine = this.txData >> this.txBit & 1;
            ++this.txBit;
        }
    }

    private String hexDataToString() {
        String s = "{";
        for (int i = 0; i < this.hexData.size(); ++i) {
            int h = (Integer)this.hexData.elementAt(i);
            s = s + Integer.toHexString(h);
            if (i == this.hexData.size() - 1) continue;
            s = s + ",";
        }
        return s + "}";
    }

    private boolean hasEvenNumberOfOnes(int data) {
        int count = 0;
        for (int i = 0; i < 8; ++i) {
            count += data >> i & 1;
        }
        return !(count & true);
    }

    private int addParityBit(int data) {
        if (this.parity == 0) {
            return data;
        }
        if (this.parity == 1) {
            if (this.hasEvenNumberOfOnes(data)) {
                data |= 0x80;
            }
            return data;
        }
        if (!this.hasEvenNumberOfOnes(data)) {
            data |= 0x80;
        }
        return data;
    }

    private boolean isValidByte(int data) {
        if (this.parity == 0) {
            return true;
        }
        if (this.parity == 1) {
            return !this.hasEvenNumberOfOnes(data);
        }
        return this.hasEvenNumberOfOnes(data);
    }

    private int clearMsb(int data) {
        if (this.parity == 0) {
            return data;
        }
        return data & 0xFFFFFF7F;
    }

    private void setBitRateInMachineCycles() {
        this.bitRateInMachineCycles = (int)Math.round(this.systemFreq * 1000000.0 / 12.0 / (double)this.baud);
    }
}

