/*
 * Decompiled with CFR 0.152.
 */
package sim8051.peripherals;

public class Keypad {
    public static final int STANDARD = 0;
    public static final int PULSE = 1;
    public static final int RADIO = 2;
    private boolean[] keysOpen = new boolean[12];
    private int[] keyBounceTimes = new int[12];
    private boolean[] justStoppedBouncing = new boolean[12];

    public Keypad() {
        for (int i = 0; i < 12; ++i) {
            this.keysOpen[i] = true;
            this.keyBounceTimes[i] = 0;
            this.justStoppedBouncing[i] = false;
        }
    }

    public void decreaseBounceTime(int keyNumber, int cycles) {
        if (this.isKeyBouncing(keyNumber)) {
            this.keyBounceTimes[keyNumber] = this.keyBounceTimes[keyNumber] - cycles;
            if (this.keyBounceTimes[keyNumber] <= 0) {
                this.keyBounceTimes[keyNumber] = 0;
                this.justStoppedBouncing[keyNumber] = true;
            }
        }
    }

    public boolean hasKeyJustStoppedBouncing(int keyNumber) {
        boolean b = this.justStoppedBouncing[keyNumber];
        if (b) {
            this.justStoppedBouncing[keyNumber] = false;
        }
        return b;
    }

    public void startKeyBounce(int keyNumber) {
        this.keyBounceTimes[keyNumber] = 30000;
    }

    public void stopKeyBounce(int keyNumber) {
        this.keyBounceTimes[keyNumber] = 0;
    }

    public boolean isKeyBouncing(int keyNumber) {
        if (this.keyBounceTimes[keyNumber] > 0) {
            return true;
        }
        this.keyBounceTimes[keyNumber] = 0;
        return false;
    }

    public boolean isKeyOpen(int keyNumber) {
        if (keyNumber < 0 || keyNumber > 11) {
            return false;
        }
        return this.keysOpen[keyNumber];
    }

    public boolean isKeyClosed(int keyNumber) {
        if (keyNumber < 0 || keyNumber > 11) {
            return false;
        }
        return !this.keysOpen[keyNumber];
    }

    public void closeKey(int keyNumber) {
        if (keyNumber < 0 || keyNumber > 11) {
            return;
        }
        this.keysOpen[keyNumber] = false;
    }

    public void openKey(int keyNumber) {
        if (keyNumber < 0 || keyNumber > 11) {
            return;
        }
        this.keysOpen[keyNumber] = true;
    }

    public void toggleKey(int keyNumber) {
        if (this.isKeyOpen(keyNumber)) {
            this.closeKey(keyNumber);
        } else {
            this.openKey(keyNumber);
        }
    }
}

