/*
 * Decompiled with CFR 0.152.
 */
package sim8051.peripherals;

import java.awt.Color;
import java.awt.Dimension;
import javax.swing.JTextField;

public class SevenSegDisplay {
    private JTextField[] segments = new JTextField[8];
    private boolean enabled = false;
    private int pattern;

    public SevenSegDisplay(JTextField a, JTextField b, JTextField c, JTextField d, JTextField e, JTextField f, JTextField g, JTextField dp) {
        this.segments[0] = a;
        this.segments[1] = b;
        this.segments[2] = c;
        this.segments[3] = d;
        this.segments[4] = e;
        this.segments[5] = f;
        this.segments[6] = g;
        this.segments[7] = dp;
    }

    public void setSegmentSize(Dimension horizontalSegmentDimension, Dimension verticalSegmentDimension, Dimension dpDimension) {
        int i;
        for (i = 0; i < 7; i += 3) {
            this.segments[i].setMaximumSize(horizontalSegmentDimension);
            this.segments[i].setMinimumSize(horizontalSegmentDimension);
            this.segments[i].setPreferredSize(horizontalSegmentDimension);
        }
        for (i = 1; i < 6; ++i) {
            if (i == 3) continue;
            this.segments[i].setMaximumSize(verticalSegmentDimension);
            this.segments[i].setMinimumSize(verticalSegmentDimension);
            this.segments[i].setPreferredSize(verticalSegmentDimension);
        }
        this.segments[7].setMaximumSize(dpDimension);
        this.segments[7].setMinimumSize(dpDimension);
        this.segments[7].setPreferredSize(dpDimension);
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void enable() {
        this.enabled = true;
        this.light();
    }

    public void disable() {
        this.enabled = false;
        this.light();
    }

    public void setEnable(boolean b) {
        this.enabled = b;
        this.light();
    }

    public void setPattern(int pattern) {
        this.pattern = pattern;
        this.light();
    }

    private void light() {
        if (this.enabled) {
            boolean mask = true;
            for (int i = 0; i < 8; ++i) {
                int bit = this.pattern >> i & 1;
                if (bit == 1) {
                    this.segments[i].setBackground(Color.WHITE);
                    continue;
                }
                this.segments[i].setBackground(Color.RED);
            }
        } else {
            for (int i = 0; i < 8; ++i) {
                this.segments[i].setBackground(Color.WHITE);
            }
        }
    }
}

