/*
 * Decompiled with CFR 0.152.
 */
package sim8051.peripherals.motor;

import java.awt.Dimension;
import sim8051.peripherals.motor.MotorGraphics;

public class Motor {
    private int shaftPosition = 2;
    private int motorCurrent;
    private int count = this.motorCurrent = 7;
    private int sensorPosition = 0;
    private boolean motorEnabled = true;
    public MotorGraphics graphicsPanel;

    public Motor(boolean size) {
        this.graphicsPanel = new MotorGraphics(size);
    }

    public void setPanelSize(boolean small) {
        this.graphicsPanel.setPanelSize(small);
    }

    public Dimension getPanelSize() {
        return new Dimension(this.graphicsPanel.getPanelSize(), this.graphicsPanel.getPanelSize());
    }

    public boolean isMotorEnabled() {
        return this.motorEnabled;
    }

    public void enableMotor() {
        this.motorEnabled = true;
    }

    public void disableMotor() {
        this.motorEnabled = false;
    }

    public boolean isSensorHigh() {
        return this.shaftPosition != this.sensorPosition;
    }

    public void setMotorCurrent(int current) {
        this.motorCurrent = current;
        if (this.count > this.motorCurrent) {
            this.count = this.motorCurrent;
        }
    }

    public void resetMotor() {
        this.shaftPosition = 2;
    }

    public void updateShaftPosition(boolean bit0, boolean bit1) {
        if (this.motorEnabled) {
            if (bit0 != bit1) {
                --this.count;
            }
            if (this.count == 0) {
                this.count = this.motorCurrent;
                if (bit0) {
                    ++this.shaftPosition;
                    if (this.shaftPosition == 8) {
                        this.shaftPosition = 0;
                    }
                } else {
                    --this.shaftPosition;
                    if (this.shaftPosition == -1) {
                        this.shaftPosition = 7;
                    }
                }
            }
        }
    }

    public void updateMotorGraphics() {
        this.graphicsPanel.setAngle(this.shaftPosition * 45);
        this.graphicsPanel.repaint();
    }
}

