/*
 * Decompiled with CFR 0.152.
 */
package sim8051.ports;

import java.util.Vector;
import sim8051.Ram;
import sim8051.Text;

public abstract class Port {
    int address;
    boolean[] pins = new boolean[8];
    Vector[] peripherals = new Vector[8];
    Ram dataMemory;
    boolean timeToUpdateGui = true;

    public Port(Ram dataMemory) {
        this.dataMemory = dataMemory;
        for (int i = 0; i < 8; ++i) {
            this.peripherals[i] = new Vector();
        }
    }

    public abstract void updatePortPins();

    public void setTimeToUpdateGui(boolean b) {
        this.timeToUpdateGui = b;
    }

    public int getPortPins() {
        int data = 0;
        for (int i = 0; i < 8; ++i) {
            if (!this.pins[i]) continue;
            data += 1 << i;
        }
        return data;
    }

    public void writePort(String data) throws Exception {
        int iData = Text.parseNumericData(data);
        if (iData != 0x1000000) {
            this.dataMemory.writeByte(this.address, iData);
        }
        this.updatePortPins();
    }

    public int getPortPin(int pinNumber) {
        if (pinNumber < 0 || pinNumber > 7) {
            return 0;
        }
        if (this.pins[pinNumber]) {
            return 1;
        }
        return 0;
    }
}

