/*
 * Decompiled with CFR 0.152.
 */
package sim8051.ports;

import java.util.Random;
import sim8051.Ram;
import sim8051.peripherals.Keypad;
import sim8051.ports.Port;

public class Port0
extends Port {
    public Keypad keypad;
    private Random random = new Random();

    public Port0(Ram dataMemory) {
        super(dataMemory);
        this.address = 128;
        this.keypad = new Keypad();
    }

    public void bounceKeys(int cycles) {
        for (int i = 0; i < 12; ++i) {
            this.keypad.decreaseBounceTime(i, cycles);
            if (this.keypad.isKeyBouncing(i)) {
                if (!this.random.nextBoolean()) continue;
                this.keypad.toggleKey(i);
                continue;
            }
            if (!this.keypad.hasKeyJustStoppedBouncing(i)) continue;
            this.keypad.closeKey(i);
        }
        this.updatePortPins();
    }

    public void updatePortPins() {
        try {
            int i;
            for (i = 0; i < 8; ++i) {
                this.pins[i] = this.dataMemory.readPortLatch(this.address + i) == 1;
            }
            for (i = 0; i < 4; ++i) {
                if (this.pins[i] || !this.keypad.isKeyClosed(i * 3)) continue;
                this.pins[4] = false;
                break;
            }
            for (i = 0; i < 4; ++i) {
                if (this.pins[i] || !this.keypad.isKeyClosed(i * 3 + 1)) continue;
                this.pins[5] = false;
                break;
            }
            for (i = 0; i < 4; ++i) {
                if (this.pins[i] || !this.keypad.isKeyClosed(i * 3 + 2)) continue;
                this.pins[6] = false;
                break;
            }
            if (!this.pins[7]) {
                this.dataMemory.port1.dac.enableInputs();
                int data = this.dataMemory.port1.getPortPins();
                if (data != this.dataMemory.port1.dac.getData()) {
                    this.dataMemory.port1.dac.latchData(data);
                    this.dataMemory.port1.dac.incrementTime();
                    this.dataMemory.port1.dac.repaint();
                    this.dataMemory.port3.comparator.setInvertingInput(data);
                }
            } else {
                this.dataMemory.port1.dac.disableInputs();
            }
            this.dataMemory.port3.updatePortPins();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

