/*
 * Decompiled with CFR 0.152.
 */
package sim8051.ports;

import java.awt.Color;
import javax.swing.JTextField;
import sim8051.Ram;
import sim8051.lcd.LcdModule;
import sim8051.peripherals.DAC;
import sim8051.peripherals.SevenSegDisplay;
import sim8051.ports.Port;

public class Port1
extends Port {
    private SevenSegDisplay[] displays = new SevenSegDisplay[4];
    private JTextField[] leds = new JTextField[8];
    private Color[] colors = new Color[8];
    public DAC dac;
    public LcdModule lcdModule;

    public Port1(Ram dataMemory) {
        super(dataMemory);
        this.address = 144;
    }

    public void addLcdModule(LcdModule lcdModule) {
        this.lcdModule = lcdModule;
    }

    public void addLedDisplays(SevenSegDisplay[] displays) {
        this.displays = displays;
    }

    public void addDAC(Color backgroundColor, Color traceColor, boolean small) {
        this.dac = new DAC(backgroundColor, traceColor, small);
    }

    public void addLeds(JTextField[] leds) {
        this.leds = leds;
        this.colors[0] = Color.RED;
        this.colors[1] = Color.ORANGE;
        this.colors[2] = Color.GREEN;
        this.colors[3] = Color.RED;
        this.colors[4] = Color.ORANGE;
        this.colors[5] = Color.GREEN;
        this.colors[6] = Color.RED;
        this.colors[7] = Color.GREEN;
    }

    public void updatePortPins() {
        try {
            int i;
            for (i = 0; i < 8; ++i) {
                this.pins[i] = this.dataMemory.readPortLatch(this.address + i) == 1;
            }
            if (this.timeToUpdateGui) {
                for (i = 0; i < this.displays.length; ++i) {
                    this.displays[i].setPattern(this.getPortPins());
                }
                this.setLedsPattern();
            }
            this.dac.latchData(this.getPortPins());
            this.dac.incrementTime();
            this.lcdModule.setDataBus(this.dataMemory.readPortLatches(this.address));
            this.lcdModule.setRs(this.dataMemory.readPortLatch(this.address + 3));
            this.lcdModule.setE(this.dataMemory.readPortLatch(this.address + 2));
            this.lcdModule.cycle();
            if (this.timeToUpdateGui) {
                this.dac.repaint();
                this.lcdModule.refreshDisplay();
            }
            this.dataMemory.port3.comparator.setInvertingInput(this.getPortPins());
            this.dataMemory.port3.updatePortPins();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void setLedsPattern() {
        for (int i = 0; i < 8; ++i) {
            if (this.pins[i]) {
                this.leds[i].setBackground(Color.WHITE);
                continue;
            }
            this.leds[i].setBackground(this.colors[i]);
        }
    }
}

