/*
 * Decompiled with CFR 0.152.
 */
package sim8051.ports;

import java.util.Random;
import sim8051.Ram;
import sim8051.ports.Port;

public class Port2
extends Port {
    private int[] switchBankBounceTimes = new int[8];
    private boolean[] switchesOpen = new boolean[8];
    private int cycles;
    private Random random = new Random();

    public Port2(Ram dataMemory) {
        super(dataMemory);
        this.address = 160;
        for (int i = 0; i < 8; ++i) {
            this.pins[i] = true;
            this.switchesOpen[i] = true;
        }
    }

    public void setCycles(int cycles) {
        this.cycles = cycles;
    }

    public void startSwitchBounce(int switchNumber) {
        this.switchBankBounceTimes[switchNumber] = 30000;
    }

    public void stopSwitchBounce(int switchNumber) {
        this.switchBankBounceTimes[switchNumber] = 0;
    }

    public void stopAllBouncing() {
        for (int i = 0; i < this.switchBankBounceTimes.length; ++i) {
            this.switchBankBounceTimes[i] = 0;
        }
    }

    public boolean isSwitchBouncing(int switchNumber) {
        if (this.switchBankBounceTimes[switchNumber] > 0) {
            return true;
        }
        this.switchBankBounceTimes[switchNumber] = 0;
        return false;
    }

    public void updatePortPins() {
        for (int i = 0; i < 8; ++i) {
            if (this.isSwitchBouncing(i)) {
                this.switchBankBounceTimes[i] = this.switchBankBounceTimes[i] - this.cycles;
                if (this.isSwitchBouncing(i)) {
                    if (!this.random.nextBoolean()) continue;
                    this.toggleSwitch(i);
                    continue;
                }
                if (!this.isSwitchOpen(i)) continue;
                this.closeSwitch(i);
                continue;
            }
            this.updateSwitch(i);
        }
    }

    private void updateSwitch(int bitNumber) {
        try {
            this.pins[bitNumber] = !this.isSwitchOpen(bitNumber) || !this.dataMemory.port3.adc.isPinHigh(bitNumber) ? false : this.dataMemory.readPortLatch(this.address + bitNumber) == 1;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public boolean isSwitchOpen(int bitNumber) {
        if (bitNumber < 0 || bitNumber > 7) {
            return false;
        }
        return this.switchesOpen[bitNumber];
    }

    public void closeSwitch(int bitNumber) {
        if (bitNumber < 0 || bitNumber > 7) {
            return;
        }
        this.switchesOpen[bitNumber] = false;
        this.updateSwitch(bitNumber);
    }

    public void openSwitch(int bitNumber) {
        if (bitNumber < 0 || bitNumber > 7) {
            return;
        }
        this.switchesOpen[bitNumber] = true;
        this.updateSwitch(bitNumber);
    }

    private void toggleSwitch(int bitNumber) {
        if (this.isSwitchOpen(bitNumber)) {
            this.closeSwitch(bitNumber);
        } else {
            this.openSwitch(bitNumber);
        }
    }
}

