/*
 * Decompiled with CFR 0.152.
 */
package sim8051.ports;

import javax.swing.JSlider;
import javax.swing.JTextArea;
import sim8051.Ram;
import sim8051.peripherals.ADC;
import sim8051.peripherals.Comparator;
import sim8051.peripherals.ExternalUart;
import sim8051.peripherals.SevenSegDisplay;
import sim8051.peripherals.motor.Motor;
import sim8051.ports.Port;

public class Port3
extends Port {
    private SevenSegDisplay[] displays = new SevenSegDisplay[4];
    private boolean rxdSwitchOpen = true;
    public boolean keypadAndGateEnabled = false;
    public Motor motor;
    public ADC adc;
    public ExternalUart uart;
    public Comparator comparator;

    public Port3(Ram dataMemory) {
        super(dataMemory);
        this.address = 176;
    }

    public void addDisplays(SevenSegDisplay[] displays) {
        this.displays = displays;
    }

    public void addMotor(boolean size) {
        this.motor = new Motor(size);
    }

    public void addExternalUart(JTextArea rxDataField, JTextArea txDataField, double systemFreq) {
        this.uart = new ExternalUart(rxDataField, txDataField, systemFreq);
    }

    public void addComparator() {
        this.comparator = new Comparator();
    }

    public void addADC(JSlider slider) {
        this.adc = new ADC(slider);
    }

    public boolean isRxdSwitchOpen() {
        return this.rxdSwitchOpen;
    }

    public void openRxdSwitch() {
        this.rxdSwitchOpen = true;
    }

    public void closeRxdSwitch() {
        this.rxdSwitchOpen = false;
    }

    public void updatePortPins() {
        try {
            for (int i = 0; i < 8; ++i) {
                this.pins[i] = this.dataMemory.readPortLatch(this.address + i) == 1;
            }
            if (this.dataMemory.readPortLatch(this.address + 3) == 1 && this.keypadAndGateEnabled) {
                this.pins[3] = this.dataMemory.port0.pins[4] && this.dataMemory.port0.pins[5] && this.dataMemory.port0.pins[6];
            }
            int enabledDisplay = this.getEnabledDisplay();
            for (int i = 0; i < 4; ++i) {
                if (i == enabledDisplay) {
                    this.displays[i].enable();
                    continue;
                }
                this.displays[i].disable();
            }
            if (!this.uart.isTxLineHigh()) {
                this.pins[0] = false;
            }
            this.uart.updateRxLine(this.pins[1]);
            if (this.dataMemory.readPortLatch(this.address + 5) == 1) {
                this.pins[5] = this.motor.isSensorHigh();
            }
            if (this.dataMemory.readPortLatch(this.address + 2) == 1) {
                this.pins[2] = this.adc.getIntr();
            }
            if (!this.comparator.isOutputHigh()) {
                this.pins[7] = false;
            }
            if (this.pins[7]) {
                this.adc.setRd();
            } else {
                this.adc.clearRd();
            }
            if (this.pins[6]) {
                this.adc.setWr();
            } else {
                this.adc.clearWr();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void updateMotor() {
        this.motor.updateShaftPosition(this.pins[0], this.pins[1]);
    }

    public boolean isPortPinHigh(int bitNumber) {
        if (bitNumber < 0 || bitNumber > 7) {
            return false;
        }
        return this.pins[bitNumber];
    }

    private int getEnabledDisplay() {
        try {
            if (this.dataMemory.getBit(135) == 0) {
                return -1;
            }
        }
        catch (Exception ex) {
            // empty catch block
        }
        int display = 0;
        if (this.pins[3]) {
            display = 1;
        }
        if (this.pins[4]) {
            display += 2;
        }
        return display;
    }
}

