/*
 * Decompiled with CFR 0.152.
 */
package sim8051.settings;

import java.io.File;
import java.io.Serializable;
import javax.swing.filechooser.FileFilter;

public class Settings
implements Serializable {
    private int instructionBatchSize = 1;
    private boolean dataMemoryDisplayed = true;
    private int codeWindowStartAddress = 0;
    private String bitfieldByteAddressString = "ACC";
    private boolean adcEnabled = true;
    private int parity = 0;
    private int baudRateIndex = 0;
    private boolean motorEnabled = true;
    private int keypadType = 0;
    private boolean keypadAndGateEnabled = false;
    private boolean ledDisplayVisible = true;
    private String lastFilePath = null;
    private String lastFileFilterDesc = null;
    private boolean small = true;
    private char[] keypadLabels = new char[]{'#', '0', '*', '9', '8', '7', '6', '5', '4', '3', '2', '1'};
    private char[] switchLabels = new char[]{'0', '1', '2', '3', '4', '5', '6', '7'};
    private boolean bounce = false;
    private double systemFreq = 12.0;

    public double getSystemFreq() {
        return this.systemFreq;
    }

    public void setSystemFreq(double d) {
        this.systemFreq = d;
    }

    public boolean isBounce() {
        return this.bounce;
    }

    public void setBounce(boolean b) {
        this.bounce = b;
    }

    public String getKeypadLabel(int keyNumber) {
        return String.valueOf(this.keypadLabels[keyNumber]);
    }

    public void setKeypadLabel(int keyNumber, char label) {
        this.keypadLabels[keyNumber] = label;
    }

    public String getSwitchLabel(int switchNumber) {
        return String.valueOf(this.switchLabels[switchNumber]);
    }

    public void setSwitchLabel(int switchNumber, char label) {
        this.switchLabels[switchNumber] = label;
    }

    public int getInstructionBatchSize() {
        return this.instructionBatchSize;
    }

    public void setInstructionBatchSize(int instructionBatchSize) {
        this.instructionBatchSize = instructionBatchSize;
    }

    public boolean isDataMemoryDisplayed() {
        return this.dataMemoryDisplayed;
    }

    public void setDataMemoryDisplayed(boolean dataMemoryDisplayed) {
        this.dataMemoryDisplayed = dataMemoryDisplayed;
    }

    public int getCodeWindowStartAddress() {
        return this.codeWindowStartAddress;
    }

    public void setCodeWindowStartAddress(int codeWindowStartAddress) {
        this.codeWindowStartAddress = codeWindowStartAddress;
    }

    public boolean isAdcEnabled() {
        return this.adcEnabled;
    }

    public void setAdcEnabled(boolean adcEnabled) {
        this.adcEnabled = adcEnabled;
    }

    public int getBaudRateIndex() {
        return this.baudRateIndex;
    }

    public void setBaudRateIndex(int baudRateIndex) {
        this.baudRateIndex = baudRateIndex;
    }

    public int getParity() {
        return this.parity;
    }

    public void setParity(int parity) {
        this.parity = parity;
    }

    public String getBitfieldByteAddressString() {
        return this.bitfieldByteAddressString;
    }

    public void setBitfieldByteAddressString(String bitfieldByteAddress) {
        this.bitfieldByteAddressString = bitfieldByteAddress;
    }

    public boolean isMotorEnabled() {
        return this.motorEnabled;
    }

    public void setMotorEnabled(boolean motorEnabled) {
        this.motorEnabled = motorEnabled;
    }

    public int getKeypadType() {
        return this.keypadType;
    }

    public void setKeypadType(int keypadType) {
        this.keypadType = keypadType;
    }

    public boolean isKeypadAndGateEnabled() {
        return this.keypadAndGateEnabled;
    }

    public void setKeypadAndGateEnabled(boolean keypadAndGateEnabled) {
        this.keypadAndGateEnabled = keypadAndGateEnabled;
    }

    public String getLastFilePath() {
        return this.lastFilePath;
    }

    public void setLastFilePath(File lastFile) {
        this.lastFilePath = lastFile.getAbsolutePath();
    }

    public String getLastFileFilterDesc() {
        return this.lastFileFilterDesc;
    }

    public void setLastFileFilterDesc(FileFilter lastFileFilter) {
        this.lastFileFilterDesc = lastFileFilter.getDescription();
    }

    public boolean isSmall() {
        return this.small;
    }

    public void setSmall(boolean isSmall) {
        this.small = isSmall;
    }

    public boolean isLedDisplayVisible() {
        return this.ledDisplayVisible;
    }

    public void setLedDisplayVisible(boolean ledDisplayVisible) {
        this.ledDisplayVisible = ledDisplayVisible;
    }
}

