/*
 * Decompiled with CFR 0.152.
 */
package sim8051.sim8051Exceptions;

import sim8051.Assembler;
import sim8051.sim8051Exceptions.Sim8051Exception;

public class UnknownLabelException
extends Sim8051Exception {
    private String label;
    private boolean isKeyword;

    public UnknownLabelException(String codeLine, String label) {
        this.codeLine = codeLine;
        this.label = label.trim();
    }

    public UnknownLabelException(String codeLine, String label, boolean isKeyword) {
        this.codeLine = codeLine;
        this.label = label;
        this.isKeyword = isKeyword;
    }

    public String toString() {
        if (this.isKeyword) {
            if (Assembler.isRegister(this.label)) {
                return "InvalidLabelException: Invalid Label - " + this.label + " is a register";
            }
            if (this.label.length() == 0) {
                return "InvalidLabelException: Label expected";
            }
            return "InvalidLabelException: Invalid Label - " + this.label + " is keyword";
        }
        if (Assembler.isRegister(this.label)) {
            return "InvalidOperandException: Invalid Operand - " + this.label + " cannot be used here";
        }
        return "UnknownLabelException: Unknown Label - " + this.label;
    }
}

