/*
 * Decompiled with CFR 0.152.
 */
package sim8051.sim8051Instructions;

import sim8051.sim8051Instructions.Instruction;
import sim8051.sim8051Instructions.add.Add;
import sim8051.sim8051Instructions.anl.Anl;
import sim8051.sim8051Instructions.branches.Branch;
import sim8051.sim8051Instructions.clr.Clr;
import sim8051.sim8051Instructions.cpl.Cpl;
import sim8051.sim8051Instructions.dec.Dec;
import sim8051.sim8051Instructions.inc.Inc;
import sim8051.sim8051Instructions.misc.Misc;
import sim8051.sim8051Instructions.mov.Mov;
import sim8051.sim8051Instructions.movc.Movc;
import sim8051.sim8051Instructions.movx.Movx;
import sim8051.sim8051Instructions.orl.Orl;
import sim8051.sim8051Instructions.rotate.Rotate;
import sim8051.sim8051Instructions.setb.Setb;
import sim8051.sim8051Instructions.subb.Subb;
import sim8051.sim8051Instructions.xch.Xch;
import sim8051.sim8051Instructions.xrl.Xrl;

public class InstructionSelector {
    private final int NUMBER_OF_TYPES = 17;
    private Instruction[] types = new Instruction[17];

    public InstructionSelector() {
        this.types[0] = new Inc();
        this.types[1] = new Movc();
        this.types[2] = new Movx();
        this.types[3] = new Mov();
        this.types[4] = new Branch();
        this.types[5] = new Setb();
        this.types[6] = new Clr();
        this.types[7] = new Add();
        this.types[8] = new Subb();
        this.types[9] = new Anl();
        this.types[10] = new Orl();
        this.types[11] = new Xrl();
        this.types[12] = new Xch();
        this.types[13] = new Rotate();
        this.types[14] = new Cpl();
        this.types[15] = new Dec();
        this.types[16] = new Misc();
    }

    private Instruction getInstructionType(String mneumonic) {
        for (int i = 0; i < 17; ++i) {
            if (!(this.types[i].mneumonic.equals("BRANCH") ? mneumonic.startsWith("JMP ") || mneumonic.startsWith("SJMP ") || mneumonic.startsWith("AJMP ") || mneumonic.startsWith("LJMP ") || mneumonic.startsWith("CALL ") || mneumonic.startsWith("ACALL ") || mneumonic.startsWith("LCALL ") || mneumonic.startsWith("RET") || mneumonic.startsWith("RETI") || mneumonic.startsWith("JZ ") || mneumonic.startsWith("JNZ ") || mneumonic.startsWith("CJNE ") || mneumonic.startsWith("DJNZ ") || mneumonic.startsWith("JC") || mneumonic.startsWith("JNC") || mneumonic.startsWith("JB") || mneumonic.startsWith("JNB") || mneumonic.startsWith("JBC") : mneumonic.startsWith(this.types[i].mneumonic))) continue;
            return this.types[i];
        }
        return this.types[this.types.length - 1];
    }

    public Instruction getInstruction(String mneumonic) {
        Instruction instructionType = this.getInstructionType(mneumonic);
        return instructionType.getInstruction(mneumonic);
    }
}

