/*
 * Decompiled with CFR 0.152.
 */
package sim8051.sim8051Instructions.anl;

import sim8051.Ram;
import sim8051.sim8051Instructions.Instruction;
import sim8051.sim8051Instructions.anl.AnlAaddress;
import sim8051.sim8051Instructions.anl.AnlAatReg;
import sim8051.sim8051Instructions.anl.AnlAdata;
import sim8051.sim8051Instructions.anl.AnlAddressA;
import sim8051.sim8051Instructions.anl.AnlAddressData;
import sim8051.sim8051Instructions.anl.AnlAreg;
import sim8051.sim8051Instructions.anl.AnlCyBit;
import sim8051.sim8051Instructions.anl.AnlCyNotBit;

public class Anl
extends Instruction {
    public Anl() {
        this.mneumonic = "ANL";
    }

    public Instruction getInstruction(String mneumonic) {
        if (mneumonic.startsWith("ANL A,")) {
            int registerNumber;
            if (mneumonic.startsWith("ANL A,#")) {
                return new AnlAdata();
            }
            if (mneumonic.length() >= 8) {
                registerNumber = mneumonic.charAt(7) - 48;
                if (mneumonic.startsWith("ANL A,R") && mneumonic.charAt(7) >= '0' && mneumonic.charAt(7) <= '7') {
                    return new AnlAreg(registerNumber);
                }
            }
            if (mneumonic.length() >= 9) {
                registerNumber = mneumonic.charAt(8) - 48;
                if (mneumonic.equals("ANL A,@R0") || mneumonic.equals("ANL A,@R1")) {
                    return new AnlAatReg(registerNumber);
                }
            }
            return new AnlAaddress();
        }
        if (mneumonic.startsWith("ANL C,/")) {
            return new AnlCyNotBit();
        }
        if (mneumonic.startsWith("ANL C,")) {
            return new AnlCyBit();
        }
        if (mneumonic.endsWith(",A")) {
            return new AnlAddressA();
        }
        int hashIndex = mneumonic.indexOf(35);
        int commaIndex = mneumonic.indexOf(44);
        if (hashIndex > 5 && commaIndex > 4) {
            return new AnlAddressData();
        }
        return null;
    }

    public int execute(Ram ram, int pc) throws Exception {
        return 0;
    }

    public int getOpcode() {
        return -1;
    }
}

