/*
 * Decompiled with CFR 0.152.
 */
package sim8051.sim8051Instructions.branches;

import sim8051.Ram;
import sim8051.Text;
import sim8051.sim8051Instructions.branches.Branch;

public class Acall
extends Branch {
    private int threeMSBs;

    public Acall(int threeMSBs) {
        this.mneumonic = "ACALL";
        this.size = 2;
        this.cycles = 2;
        this.threeMSBs = threeMSBs;
    }

    public Acall() {
        this(0);
    }

    public int execute(Ram ram, int pc) throws Exception {
        pc += 2;
        int sp = ram.readByte(129);
        if (++sp == 256) {
            sp = 0;
        }
        ram.writeByte(129, sp);
        ram.writeByte(sp, pc & 0xFF);
        if (++sp == 256) {
            sp = 0;
        }
        ram.writeByte(129, sp);
        ram.writeByte(sp, pc >> 8);
        int pageAddress = (this.threeMSBs << 8) + this.operand0;
        pc &= 0xF800;
        return pc += pageAddress;
    }

    public String toString() {
        int address = (this.threeMSBs << 8) + this.operand0;
        return "ACALL " + Text.inHex(address, false, 3) + "H";
    }

    public int getOpcode() {
        return (this.threeMSBs << 5) + 17;
    }
}

