/*
 * Decompiled with CFR 0.152.
 */
package sim8051.sim8051Instructions.branches;

import sim8051.Ram;
import sim8051.sim8051Instructions.Instruction;
import sim8051.sim8051Instructions.branches.Acall;
import sim8051.sim8051Instructions.branches.Ajmp;
import sim8051.sim8051Instructions.branches.Call;
import sim8051.sim8051Instructions.branches.CjneAaddress;
import sim8051.sim8051Instructions.branches.CjneAdata;
import sim8051.sim8051Instructions.branches.CjneAtRegData;
import sim8051.sim8051Instructions.branches.CjneRegData;
import sim8051.sim8051Instructions.branches.DjnzData;
import sim8051.sim8051Instructions.branches.DjnzReg;
import sim8051.sim8051Instructions.branches.Jb;
import sim8051.sim8051Instructions.branches.Jbc;
import sim8051.sim8051Instructions.branches.Jc;
import sim8051.sim8051Instructions.branches.Jmp;
import sim8051.sim8051Instructions.branches.JmpDptr;
import sim8051.sim8051Instructions.branches.Jnb;
import sim8051.sim8051Instructions.branches.Jnc;
import sim8051.sim8051Instructions.branches.Jnz;
import sim8051.sim8051Instructions.branches.Jz;
import sim8051.sim8051Instructions.branches.Lcall;
import sim8051.sim8051Instructions.branches.Ljmp;
import sim8051.sim8051Instructions.branches.Ret;
import sim8051.sim8051Instructions.branches.Reti;
import sim8051.sim8051Instructions.branches.Sjmp;

public class Branch
extends Instruction {
    public Branch() {
        this.mneumonic = "BRANCH";
    }

    private String removeWhitespace(String mneumonic) {
        return mneumonic.replaceAll(" ", "");
    }

    public Instruction getInstruction(String mneumonic) {
        int registerNumber;
        if (mneumonic.startsWith("JMP ") && this.removeWhitespace(mneumonic).endsWith("@A+DPTR")) {
            return new JmpDptr();
        }
        if (mneumonic.startsWith("JMP ")) {
            return new Jmp();
        }
        if (mneumonic.startsWith("SJMP ")) {
            return new Sjmp();
        }
        if (mneumonic.startsWith("AJMP ")) {
            return new Ajmp();
        }
        if (mneumonic.startsWith("LJMP ")) {
            return new Ljmp();
        }
        if (mneumonic.startsWith("CALL ")) {
            return new Call();
        }
        if (mneumonic.startsWith("ACALL ")) {
            return new Acall();
        }
        if (mneumonic.startsWith("LCALL ")) {
            return new Lcall();
        }
        if (mneumonic.equals("RET")) {
            return new Ret();
        }
        if (mneumonic.equals("RETI")) {
            return new Reti();
        }
        if (mneumonic.startsWith("JZ ")) {
            return new Jz();
        }
        if (mneumonic.startsWith("JNZ ")) {
            return new Jnz();
        }
        if (mneumonic.startsWith("CJNE A,#")) {
            return new CjneAdata();
        }
        if (mneumonic.startsWith("CJNE A,")) {
            return new CjneAaddress();
        }
        if (mneumonic.length() >= 10) {
            registerNumber = mneumonic.charAt(7) - 48;
            if (mneumonic.startsWith("CJNE @R") && mneumonic.charAt(9) == '#' && (mneumonic.charAt(7) == '0' || mneumonic.charAt(7) == '1')) {
                return new CjneAtRegData(registerNumber);
            }
        }
        if (mneumonic.length() >= 9) {
            registerNumber = mneumonic.charAt(6) - 48;
            if (mneumonic.startsWith("CJNE R") && mneumonic.charAt(8) == '#' && mneumonic.charAt(6) >= '0' && mneumonic.charAt(6) <= '7') {
                return new CjneRegData(registerNumber);
            }
        }
        if (mneumonic.length() >= 7) {
            registerNumber = mneumonic.charAt(6) - 48;
            if (mneumonic.startsWith("DJNZ R") && mneumonic.charAt(6) >= '0' && mneumonic.charAt(6) <= '7') {
                return new DjnzReg(registerNumber);
            }
        }
        if (mneumonic.startsWith("DJNZ ")) {
            return new DjnzData();
        }
        if (mneumonic.startsWith("JC")) {
            return new Jc();
        }
        if (mneumonic.startsWith("JNC")) {
            return new Jnc();
        }
        if (mneumonic.startsWith("JBC")) {
            return new Jbc();
        }
        if (mneumonic.startsWith("JB")) {
            return new Jb();
        }
        if (mneumonic.startsWith("JNB")) {
            return new Jnb();
        }
        return null;
    }

    public int execute(Ram ram, int pc) throws Exception {
        return 0;
    }

    public int getOpcode() {
        return -1;
    }
}

