/*
 * Decompiled with CFR 0.152.
 */
package sim8051.sim8051Instructions.branches;

import sim8051.Ram;
import sim8051.Text;
import sim8051.sim8051Instructions.branches.Branch;

public class DjnzData
extends Branch {
    public DjnzData() {
        this.mneumonic = "DJNZ";
        this.size = 3;
        this.cycles = 2;
    }

    public int execute(Ram ram, int pc) throws Exception {
        int data;
        if ((pc += this.size) > 65535) {
            pc -= 65536;
        }
        if ((data = ram.readByte(this.operand0) - 1) == -1) {
            data = 255;
        }
        ram.writeByte(this.operand0, data);
        if (data != 0) {
            if ((pc += ram.toSignedNumber(this.operand1)) > 65535) {
                pc -= 65536;
            } else if (pc < 0) {
                pc = 65536 + pc;
            }
        }
        return pc;
    }

    public void extractOperand0String(String line) throws Exception {
        int commaIndex = (line = line.replaceFirst(this.mneumonic, "").trim()).indexOf(44);
        line = commaIndex == -1 ? "" : line.substring(0, commaIndex).trim();
        this.setOperand0String(line);
    }

    public void extractOperand1String(String line) throws Exception {
        int commaIndex = (line = line.replaceFirst(this.mneumonic, "").trim()).indexOf(44);
        line = commaIndex == -1 ? "" : line.substring(commaIndex + 1).trim();
        this.setOperand1String(line);
    }

    public String toString() {
        return "DJNZ " + Text.inHex(this.operand0, false) + "H," + Text.inHex(this.operand1, false) + "H";
    }

    public int getOpcode() {
        return 213;
    }
}

