/*
 * Decompiled with CFR 0.152.
 */
package sim8051.sim8051Instructions.branches;

import sim8051.Ram;
import sim8051.Text;
import sim8051.sim8051Instructions.branches.Branch;

public class Lcall
extends Branch {
    public Lcall() {
        this.mneumonic = "LCALL";
        this.size = 3;
        this.cycles = 2;
    }

    public int execute(Ram ram, int pc) throws Exception {
        pc += 3;
        int sp = ram.readByte(129);
        if (++sp == 256) {
            sp = 0;
        }
        ram.writeByte(129, sp);
        ram.writeByte(sp, pc & 0xFF);
        if (++sp == 256) {
            sp = 0;
        }
        ram.writeByte(129, sp);
        ram.writeByte(sp, pc >> 8);
        return (this.operand0 << 8) + this.operand1;
    }

    public void extractOperand1String(String line) throws Exception {
        this.setOperand1String(line.replaceFirst(this.mneumonic, ""));
    }

    public String toString() {
        return "LCALL " + Text.inHex(this.operand0, false) + Text.inHex(this.operand1, false, 2, false) + "H";
    }

    public int getOpcode() {
        return 18;
    }
}

