/*
 * Decompiled with CFR 0.152.
 */
package sim8051.sim8051Instructions.inc;

import sim8051.Ram;
import sim8051.sim8051Instructions.Instruction;
import sim8051.sim8051Instructions.inc.IncA;
import sim8051.sim8051Instructions.inc.IncAddress;
import sim8051.sim8051Instructions.inc.IncAtReg;
import sim8051.sim8051Instructions.inc.IncDptr;
import sim8051.sim8051Instructions.inc.IncReg;

public class Inc
extends Instruction {
    public Inc() {
        this.mneumonic = "INC";
    }

    public Instruction getInstruction(String mneumonic) {
        if (mneumonic.equals("INC A")) {
            return new IncA();
        }
        if (mneumonic.equals("INC DPTR")) {
            return new IncDptr();
        }
        int registerNumber = mneumonic.charAt(mneumonic.length() - 1) - 48;
        if (mneumonic.startsWith("INC R") && mneumonic.charAt(mneumonic.length() - 1) >= '0' && mneumonic.charAt(mneumonic.length() - 1) <= '7') {
            return new IncReg(registerNumber);
        }
        if (mneumonic.equals("INC @R0") || mneumonic.equals("INC @R1")) {
            return new IncAtReg(registerNumber);
        }
        return new IncAddress();
    }

    public int execute(Ram ram, int pc) throws Exception {
        return 0;
    }

    public int getOpcode() {
        return -1;
    }
}

