/*
 * Decompiled with CFR 0.152.
 */
package sim8051.sim8051Instructions.mov;

import sim8051.Ram;
import sim8051.sim8051Instructions.Instruction;
import sim8051.sim8051Instructions.mov.MovAaddress;
import sim8051.sim8051Instructions.mov.MovAatReg;
import sim8051.sim8051Instructions.mov.MovAdata;
import sim8051.sim8051Instructions.mov.MovAddressA;
import sim8051.sim8051Instructions.mov.MovAddressAddress;
import sim8051.sim8051Instructions.mov.MovAddressAtReg;
import sim8051.sim8051Instructions.mov.MovAddressData;
import sim8051.sim8051Instructions.mov.MovAddressReg;
import sim8051.sim8051Instructions.mov.MovAreg;
import sim8051.sim8051Instructions.mov.MovAtRegA;
import sim8051.sim8051Instructions.mov.MovAtRegAddress;
import sim8051.sim8051Instructions.mov.MovAtRegData;
import sim8051.sim8051Instructions.mov.MovBitCy;
import sim8051.sim8051Instructions.mov.MovCyBit;
import sim8051.sim8051Instructions.mov.MovDptrData;
import sim8051.sim8051Instructions.mov.MovRegA;
import sim8051.sim8051Instructions.mov.MovRegAddress;
import sim8051.sim8051Instructions.mov.MovRegData;

public class Mov
extends Instruction {
    public Mov() {
        this.mneumonic = "MOV";
    }

    public Instruction getInstruction(String mneumonic) {
        if (mneumonic.startsWith("MOV DPTR,#")) {
            return new MovDptrData();
        }
        if (mneumonic.startsWith("MOV A,")) {
            int registerNumber;
            if (mneumonic.startsWith("MOV A,#")) {
                return new MovAdata();
            }
            if (mneumonic.length() >= 8) {
                registerNumber = mneumonic.charAt(7) - 48;
                if (mneumonic.startsWith("MOV A,R") && mneumonic.charAt(7) >= '0' && mneumonic.charAt(7) <= '7') {
                    return new MovAreg(registerNumber);
                }
            }
            if (mneumonic.length() >= 9) {
                registerNumber = mneumonic.charAt(8) - 48;
                if (mneumonic.equals("MOV A,@R0") || mneumonic.equals("MOV A,@R1")) {
                    return new MovAatReg(registerNumber);
                }
            }
            return new MovAaddress();
        }
        if (mneumonic.length() >= 8 && mneumonic.startsWith("MOV R") && mneumonic.charAt(5) >= '0' && mneumonic.charAt(5) <= '7' && mneumonic.charAt(6) == ',') {
            int registerNumber = mneumonic.charAt(5) - 48;
            String end = mneumonic.substring(7).trim();
            if (end.equals("A")) {
                return new MovRegA(registerNumber);
            }
            if (end.charAt(0) == '#') {
                return new MovRegData(registerNumber);
            }
            return new MovRegAddress(registerNumber);
        }
        if ((mneumonic.startsWith("MOV @R0,") || mneumonic.startsWith("MOV @R1,")) && mneumonic.length() >= 7) {
            int registerNumber = mneumonic.charAt(6) - 48;
            String end = mneumonic.substring(8).trim();
            if (end.equals("A")) {
                return new MovAtRegA(registerNumber);
            }
            if (end.charAt(0) == '#') {
                return new MovAtRegData(registerNumber);
            }
            return new MovAtRegAddress(registerNumber);
        }
        if (mneumonic.startsWith("MOV C,")) {
            return new MovCyBit();
        }
        if (mneumonic.endsWith(",A")) {
            return new MovAddressA();
        }
        if (mneumonic.endsWith(",C")) {
            return new MovBitCy();
        }
        int registerNumber = mneumonic.charAt(mneumonic.length() - 1) - 48;
        String temp = mneumonic.substring(0, mneumonic.length() - 1);
        if (temp.endsWith(",R")) {
            return new MovAddressReg(registerNumber);
        }
        if ((registerNumber == 0 || registerNumber == 1) && temp.endsWith(",@R")) {
            return new MovAddressAtReg(registerNumber);
        }
        int hashIndex = temp.indexOf(35);
        int commaIndex = temp.indexOf(44);
        if (hashIndex > 5 && commaIndex > 4) {
            return new MovAddressData();
        }
        if (commaIndex > 4) {
            return new MovAddressAddress();
        }
        return null;
    }

    public int execute(Ram ram, int pc) throws Exception {
        return 0;
    }

    public int getOpcode() {
        return -1;
    }
}

