/*
 * Decompiled with CFR 0.152.
 */
package sim8051.sim8051Instructions.mov;

import sim8051.Ram;
import sim8051.Text;
import sim8051.sim8051Instructions.mov.Mov;

public class MovAddressAtReg
extends Mov {
    private int registerNumber;

    public MovAddressAtReg(int registerNumber) {
        this.registerNumber = registerNumber;
        this.mneumonic = "MOV direct,@Rn";
        this.size = 2;
        this.cycles = 2;
    }

    public int execute(Ram ram, int pc) throws Exception {
        ram.writeByte(this.operand0, ram.readByte(ram.readRegister(this.registerNumber)));
        return this.incrementPc(pc);
    }

    public void extractOperand0String(String line) throws Exception {
        line = line.replaceFirst("MOV", "").trim();
        line = line.replaceFirst(",@R" + this.registerNumber, "").trim();
        this.setOperand0String(line);
    }

    public String toString() {
        return "MOV " + Text.inHex(this.operand0, false) + "H,@R" + this.registerNumber;
    }

    public int getOpcode() {
        return 134 + this.registerNumber;
    }
}

