/*
 * Decompiled with CFR 0.152.
 */
package sim8051.sim8051Instructions.orl;

import sim8051.Ram;
import sim8051.sim8051Instructions.Instruction;
import sim8051.sim8051Instructions.orl.OrlAaddress;
import sim8051.sim8051Instructions.orl.OrlAatReg;
import sim8051.sim8051Instructions.orl.OrlAdata;
import sim8051.sim8051Instructions.orl.OrlAddressA;
import sim8051.sim8051Instructions.orl.OrlAddressData;
import sim8051.sim8051Instructions.orl.OrlAreg;
import sim8051.sim8051Instructions.orl.OrlCyBit;
import sim8051.sim8051Instructions.orl.OrlCyNotBit;

public class Orl
extends Instruction {
    public Orl() {
        this.mneumonic = "ORL";
    }

    public Instruction getInstruction(String mneumonic) {
        if (mneumonic.startsWith("ORL A,")) {
            int registerNumber;
            if (mneumonic.startsWith("ORL A,#")) {
                return new OrlAdata();
            }
            if (mneumonic.length() >= 8) {
                registerNumber = mneumonic.charAt(7) - 48;
                if (mneumonic.startsWith("ORL A,R") && mneumonic.charAt(7) >= '0' && mneumonic.charAt(7) <= '7') {
                    return new OrlAreg(registerNumber);
                }
            }
            if (mneumonic.length() >= 9) {
                registerNumber = mneumonic.charAt(8) - 48;
                if (mneumonic.equals("ORL A,@R0") || mneumonic.equals("ORL A,@R1")) {
                    return new OrlAatReg(registerNumber);
                }
            }
            return new OrlAaddress();
        }
        if (mneumonic.startsWith("ORL C,/")) {
            return new OrlCyNotBit();
        }
        if (mneumonic.startsWith("ORL C,")) {
            return new OrlCyBit();
        }
        if (mneumonic.endsWith(",A")) {
            return new OrlAddressA();
        }
        int hashIndex = mneumonic.indexOf(35);
        int commaIndex = mneumonic.indexOf(44);
        if (hashIndex > 5 && commaIndex > 4) {
            return new OrlAddressData();
        }
        return null;
    }

    public int execute(Ram ram, int pc) throws Exception {
        return 0;
    }

    public int getOpcode() {
        return -1;
    }
}

