/*
 * Decompiled with CFR 0.152.
 */
package sim8051.sim8051Instructions.subb;

import sim8051.Ram;
import sim8051.sim8051Instructions.Instruction;
import sim8051.sim8051Instructions.subb.SubbAaddress;
import sim8051.sim8051Instructions.subb.SubbAatReg;
import sim8051.sim8051Instructions.subb.SubbAdata;
import sim8051.sim8051Instructions.subb.SubbAreg;

public class Subb
extends Instruction {
    public Subb() {
        this.mneumonic = "SUBB";
    }

    public Instruction getInstruction(String mneumonic) {
        if (mneumonic.startsWith("SUBB A,")) {
            int registerNumber;
            if (mneumonic.startsWith("SUBB A,#")) {
                return new SubbAdata();
            }
            if (mneumonic.length() >= 9) {
                registerNumber = mneumonic.charAt(8) - 48;
                if (mneumonic.startsWith("SUBB A,R") && mneumonic.charAt(8) >= '0' && mneumonic.charAt(8) <= '7') {
                    return new SubbAreg(registerNumber);
                }
            }
            if (mneumonic.length() >= 10) {
                registerNumber = mneumonic.charAt(9) - 48;
                if (mneumonic.equals("SUBB A,@R0") || mneumonic.equals("SUBB A,@R1")) {
                    return new SubbAatReg(registerNumber);
                }
            }
            return new SubbAaddress();
        }
        return null;
    }

    public int execute(Ram ram, int pc) throws Exception {
        return 0;
    }

    public int getOpcode() {
        return -1;
    }

    public void subtractFromAWithC(Ram ram, int data) throws Exception {
        int a = ram.readByte(224);
        int result = a - (data += ram.getBit(215));
        if (result < 0) {
            result += 256;
            ram.setBit(215);
        } else {
            ram.clearBit(215);
        }
        ram.writeByte(224, result);
        int signedResult = ram.toSignedNumber(a) - ram.toSignedNumber(data);
        if (signedResult > 127 || signedResult < -128) {
            ram.setBit(210);
        } else {
            ram.clearBit(210);
        }
        int aLowNibble = a & 0xF;
        int dataLowNibble = data & 0xF;
        if (aLowNibble < dataLowNibble) {
            ram.setBit(214);
        } else {
            ram.clearBit(214);
        }
    }
}

