/*
 * Decompiled with CFR 0.152.
 */
package sim8051.sim8051Instructions.xch;

import sim8051.Ram;
import sim8051.sim8051Instructions.Instruction;
import sim8051.sim8051Instructions.xch.XchAaddress;
import sim8051.sim8051Instructions.xch.XchAatReg;
import sim8051.sim8051Instructions.xch.XchAreg;
import sim8051.sim8051Instructions.xch.XchdAatReg;

public class Xch
extends Instruction {
    public Xch() {
        this.mneumonic = "XCH";
    }

    public Instruction getInstruction(String mneumonic) {
        if (mneumonic.startsWith("XCH A,")) {
            int registerNumber;
            if (mneumonic.length() >= 8) {
                registerNumber = mneumonic.charAt(7) - 48;
                if (mneumonic.startsWith("XCH A,R") && mneumonic.charAt(7) >= '0' && mneumonic.charAt(7) <= '7') {
                    return new XchAreg(registerNumber);
                }
            }
            if (mneumonic.length() >= 9) {
                registerNumber = mneumonic.charAt(8) - 48;
                if (mneumonic.equals("XCH A,@R0") || mneumonic.equals("XCH A,@R1")) {
                    return new XchAatReg(registerNumber);
                }
            }
            return new XchAaddress();
        }
        if (mneumonic.length() >= 10) {
            int registerNumber = mneumonic.charAt(9) - 48;
            if (mneumonic.equals("XCHD A,@R0") || mneumonic.equals("XCHD A,@R1")) {
                return new XchdAatReg(registerNumber);
            }
        }
        return null;
    }

    public int execute(Ram ram, int pc) throws Exception {
        return 0;
    }

    public int getOpcode() {
        return -1;
    }
}

