/*
 * Decompiled with CFR 0.152.
 */
package sim8051.sim8051Instructions.xrl;

import sim8051.Ram;
import sim8051.sim8051Instructions.Instruction;
import sim8051.sim8051Instructions.xrl.XrlAaddress;
import sim8051.sim8051Instructions.xrl.XrlAatReg;
import sim8051.sim8051Instructions.xrl.XrlAdata;
import sim8051.sim8051Instructions.xrl.XrlAddressA;
import sim8051.sim8051Instructions.xrl.XrlAddressData;
import sim8051.sim8051Instructions.xrl.XrlAreg;

public class Xrl
extends Instruction {
    public Xrl() {
        this.mneumonic = "XRL";
    }

    public Instruction getInstruction(String mneumonic) {
        if (mneumonic.startsWith("XRL A,")) {
            int registerNumber;
            if (mneumonic.startsWith("XRL A,#")) {
                return new XrlAdata();
            }
            if (mneumonic.length() >= 8) {
                registerNumber = mneumonic.charAt(7) - 48;
                if (mneumonic.startsWith("XRL A,R") && mneumonic.charAt(7) >= '0' && mneumonic.charAt(7) <= '7') {
                    return new XrlAreg(registerNumber);
                }
            }
            if (mneumonic.length() >= 9) {
                registerNumber = mneumonic.charAt(8) - 48;
                if (mneumonic.equals("XRL A,@R0") || mneumonic.equals("XRL A,@R1")) {
                    return new XrlAatReg(registerNumber);
                }
            }
            return new XrlAaddress();
        }
        if (mneumonic.endsWith(",A")) {
            return new XrlAddressA();
        }
        int hashIndex = mneumonic.indexOf(35);
        int commaIndex = mneumonic.indexOf(44);
        if (hashIndex > 5 && commaIndex > 4) {
            return new XrlAddressData();
        }
        return null;
    }

    public int execute(Ram ram, int pc) throws Exception {
        return 0;
    }

    public int getOpcode() {
        return -1;
    }
}

