<?php

/**
 * seller actions.
 *
 * @package    balsit
 * @subpackage seller
 * @author     Your name here
 * @version    SVN: $Id: actions.class.php 23810 2009-11-12 11:07:44Z Kris.Wallsmith $
 */
class sellerActions extends sfActions
{
	public function executeIndex(sfWebRequest $request)
	{
		$this->boards = Doctrine::getTable('Board')
		->createQuery('Board')
		->innerJoin('Board.Seats')
		->execute();
	}

	public function executeShow(sfWebRequest $request)
	{
		$this->seat = Doctrine::getTable('Seat')->find(array($request->getParameter('id')));
		$this->forward404Unless($this->seat);
	}

	public function executeNew(sfWebRequest $request)
	{
		$this->form = new SeatForm();
	}

	public function executeCreate(sfWebRequest $request)
	{
		$this->forward404Unless($request->isMethod(sfRequest::POST));

		$this->form = new SeatForm();

		$this->processForm($request, $this->form);

		$this->setTemplate('new');
	}

	public function executeEdit(sfWebRequest $request)
	{
		$this->forward404Unless($seat = Doctrine::getTable('Seat')->find(array($request->getParameter('id'))), sprintf('Object seat does not exist (%s).', $request->getParameter('id')));
		$this->form = new SeatForm($seat);
	}
	public function executeSell(sfWebRequest $request)
	{
		$this->forward404Unless($seat = Doctrine::getTable('Seat')->find(array($request->getParameter('id'))), sprintf('Object seat does not exist (%s).', $request->getParameter('id')));
		$this->id=$request->getParameter('id');
		if($request->getMethod()==sfRequest::POST)
		{
			$form = new SeatSellForm($seat);
			$form->bind($request->getParameter($form->getName()), $request->getFiles($form->getName()));
			if ($form->isValid())
			{
				$seat = $form->save();
				$seat->setSold(true);
				$dateFormat = new sfDateFormat();
				$value = $dateFormat->format(time(), 'I');
				$seat->setSoldTime($value);
				$user=$this->getUser()->getGuardUser();
				$seat->setSfGuardUser($user);
				$part=$seat->getPartnerSeatId();
				if($part)
				{
					$this->forward404Unless($partner_seat = Doctrine::getTable('Seat')->find(array($part)), sprintf('Partner object seat does not exist (%s).', $part));

					$partner_seat->setSeat($seat);
					$seat->save();
					$partner_seat->save();
					if(!$partner_seat->getGuestId())
					$this->redirect('seller/sell?id='.$part);
					else
					$this->redirect('seller/index');
				}
				$seat->save();

				$this->redirect('seller/index');
			}
			else
			{
				$this->form=$form;
			}
		}
		else
		{
			$this->redirectIf($seat->getSold(),'seller/edit?id='.$seat->getId());

			$seat->setPrice(100);

			//die(print_r($this->getUser()->getGuardUser()->toArray(),true));
			$this->form = new SeatSellForm($seat);
		}
	}

	public function executeUpdate(sfWebRequest $request)
	{
		$this->forward404Unless($request->isMethod(sfRequest::POST) || $request->isMethod(sfRequest::PUT));
		$this->forward404Unless($seat = Doctrine::getTable('Seat')->find(array($request->getParameter('id'))), sprintf('Object seat does not exist (%s).', $request->getParameter('id')));
		$this->form = new SeatForm($seat);

		$this->processForm($request, $this->form);

		$this->setTemplate('edit');
	}

	public function executeDelete(sfWebRequest $request)
	{
		$request->checkCSRFProtection();

		$this->forward404Unless($seat = Doctrine::getTable('Seat')->find(array($request->getParameter('id'))), sprintf('Object seat does not exist (%s).', $request->getParameter('id')));
		$seat->delete();

		$this->redirect('seller/index');
	}

	protected function processForm(sfWebRequest $request, sfForm $form)
	{
		$form->bind($request->getParameter($form->getName()), $request->getFiles($form->getName()));
		if ($form->isValid())
		{
			$seat = $form->save();

			$this->redirect('seller/edit?id='.$seat->getId());
		}
	}
}
