<?php

/**
 * Guest filter form base class.
 *
 * @package    balsit
 * @subpackage filter
 * @author     Krzysiek Wesołowski
 * @version    SVN: $Id: sfDoctrineFormFilterGeneratedTemplate.php 24171 2009-11-19 16:37:50Z Kris.Wallsmith $
 */
abstract class BaseGuestFormFilter extends BaseFormFilterDoctrine
{
  public function setup()
  {
    $this->setWidgets(array(
      'gender_id'  => new sfWidgetFormDoctrineChoice(array('model' => $this->getRelatedModelName('Gender'), 'add_empty' => true)),
      'title'      => new sfWidgetFormFilterInput(),
      'name'       => new sfWidgetFormFilterInput(array('with_empty' => false)),
      'surname'    => new sfWidgetFormFilterInput(array('with_empty' => false)),
      'university' => new sfWidgetFormFilterInput(array('with_empty' => false)),
      'index_nr'   => new sfWidgetFormFilterInput(),
      'telephone'  => new sfWidgetFormFilterInput(),
      'email'      => new sfWidgetFormFilterInput(array('with_empty' => false)),
      'created_at' => new sfWidgetFormFilterDate(array('from_date' => new sfWidgetFormDate(), 'to_date' => new sfWidgetFormDate(), 'with_empty' => false)),
      'updated_at' => new sfWidgetFormFilterDate(array('from_date' => new sfWidgetFormDate(), 'to_date' => new sfWidgetFormDate(), 'with_empty' => false)),
    ));

    $this->setValidators(array(
      'gender_id'  => new sfValidatorDoctrineChoice(array('required' => false, 'model' => $this->getRelatedModelName('Gender'), 'column' => 'id')),
      'title'      => new sfValidatorPass(array('required' => false)),
      'name'       => new sfValidatorPass(array('required' => false)),
      'surname'    => new sfValidatorPass(array('required' => false)),
      'university' => new sfValidatorPass(array('required' => false)),
      'index_nr'   => new sfValidatorSchemaFilter('text', new sfValidatorInteger(array('required' => false))),
      'telephone'  => new sfValidatorPass(array('required' => false)),
      'email'      => new sfValidatorPass(array('required' => false)),
      'created_at' => new sfValidatorDateRange(array('required' => false, 'from_date' => new sfValidatorDateTime(array('required' => false, 'datetime_output' => 'Y-m-d 00:00:00')), 'to_date' => new sfValidatorDateTime(array('required' => false, 'datetime_output' => 'Y-m-d 23:59:59')))),
      'updated_at' => new sfValidatorDateRange(array('required' => false, 'from_date' => new sfValidatorDateTime(array('required' => false, 'datetime_output' => 'Y-m-d 00:00:00')), 'to_date' => new sfValidatorDateTime(array('required' => false, 'datetime_output' => 'Y-m-d 23:59:59')))),
    ));

    $this->widgetSchema->setNameFormat('guest_filters[%s]');

    $this->errorSchema = new sfValidatorErrorSchema($this->validatorSchema);

    $this->setupInheritance();

    parent::setup();
  }

  public function getModelName()
  {
    return 'Guest';
  }

  public function getFields()
  {
    return array(
      'id'         => 'Number',
      'gender_id'  => 'ForeignKey',
      'title'      => 'Text',
      'name'       => 'Text',
      'surname'    => 'Text',
      'university' => 'Text',
      'index_nr'   => 'Number',
      'telephone'  => 'Text',
      'email'      => 'Text',
      'created_at' => 'Date',
      'updated_at' => 'Date',
    );
  }
}
