<?php

/**
 * Seat form base class.
 *
 * @method Seat getObject() Returns the current form's model object
 *
 * @package    balsit
 * @subpackage form
 * @author     Krzysiek Wesołowski
 * @version    SVN: $Id: sfDoctrineFormGeneratedTemplate.php 24171 2009-11-19 16:37:50Z Kris.Wallsmith $
 */
abstract class BaseSeatForm extends BaseFormDoctrine
{
  public function setup()
  {
    $this->setWidgets(array(
      'id'              => new sfWidgetFormInputHidden(),
      'board_id'        => new sfWidgetFormDoctrineChoice(array('model' => $this->getRelatedModelName('Board'), 'add_empty' => false)),
      'seller_id'       => new sfWidgetFormDoctrineChoice(array('model' => $this->getRelatedModelName('sfGuardUser'), 'add_empty' => true)),
      'guest_id'        => new sfWidgetFormDoctrineChoice(array('model' => $this->getRelatedModelName('Guest'), 'add_empty' => true)),
      'partner_seat_id' => new sfWidgetFormDoctrineChoice(array('model' => $this->getRelatedModelName('Seat'), 'add_empty' => true)),
      'sold_time'       => new sfWidgetFormDateTime(),
      'price'           => new sfWidgetFormInputText(),
      'comment'         => new sfWidgetFormTextarea(),
      'sold'            => new sfWidgetFormInputCheckbox(),
    ));

    $this->setValidators(array(
      'id'              => new sfValidatorDoctrineChoice(array('model' => $this->getModelName(), 'column' => 'id', 'required' => false)),
      'board_id'        => new sfValidatorDoctrineChoice(array('model' => $this->getRelatedModelName('Board'))),
      'seller_id'       => new sfValidatorDoctrineChoice(array('model' => $this->getRelatedModelName('sfGuardUser'), 'required' => false)),
      'guest_id'        => new sfValidatorDoctrineChoice(array('model' => $this->getRelatedModelName('Guest'), 'required' => false)),
      'partner_seat_id' => new sfValidatorDoctrineChoice(array('model' => $this->getRelatedModelName('Seat'), 'required' => false)),
      'sold_time'       => new sfValidatorDateTime(array('required' => false)),
      'price'           => new sfValidatorNumber(array('required' => false)),
      'comment'         => new sfValidatorString(array('max_length' => 1000, 'required' => false)),
      'sold'            => new sfValidatorBoolean(array('required' => false)),
    ));

    $this->validatorSchema->setPostValidator(
      new sfValidatorDoctrineUnique(array('model' => 'Seat', 'column' => array('partner_seat_id')))
    );

    $this->widgetSchema->setNameFormat('seat[%s]');

    $this->errorSchema = new sfValidatorErrorSchema($this->validatorSchema);

    $this->setupInheritance();

    parent::setup();
  }

  public function getModelName()
  {
    return 'Seat';
  }

}
