<?php

/**
 * BaseSeat
 * 
 * This class has been auto-generated by the Doctrine ORM Framework
 * 
 * @property integer $board_id
 * @property integer $seller_id
 * @property integer $guest_id
 * @property integer $partner_seat_id
 * @property timestamp $sold_time
 * @property float $price
 * @property string $comment
 * @property boolean $sold
 * @property sfGuardUser $sfGuardUser
 * @property Board $Board
 * @property Guest $Guest
 * @property Seat $Seat
 * 
 * @method integer     getBoardId()         Returns the current record's "board_id" value
 * @method integer     getSellerId()        Returns the current record's "seller_id" value
 * @method integer     getGuestId()         Returns the current record's "guest_id" value
 * @method integer     getPartnerSeatId()   Returns the current record's "partner_seat_id" value
 * @method timestamp   getSoldTime()        Returns the current record's "sold_time" value
 * @method float       getPrice()           Returns the current record's "price" value
 * @method string      getComment()         Returns the current record's "comment" value
 * @method boolean     getSold()            Returns the current record's "sold" value
 * @method sfGuardUser getSfGuardUser()     Returns the current record's "sfGuardUser" value
 * @method Board       getBoard()           Returns the current record's "Board" value
 * @method Guest       getGuest()           Returns the current record's "Guest" value
 * @method Seat        getSeat()            Returns the current record's "Seat" value
 * @method Seat        setBoardId()         Sets the current record's "board_id" value
 * @method Seat        setSellerId()        Sets the current record's "seller_id" value
 * @method Seat        setGuestId()         Sets the current record's "guest_id" value
 * @method Seat        setPartnerSeatId()   Sets the current record's "partner_seat_id" value
 * @method Seat        setSoldTime()        Sets the current record's "sold_time" value
 * @method Seat        setPrice()           Sets the current record's "price" value
 * @method Seat        setComment()         Sets the current record's "comment" value
 * @method Seat        setSold()            Sets the current record's "sold" value
 * @method Seat        setSfGuardUser()     Sets the current record's "sfGuardUser" value
 * @method Seat        setBoard()           Sets the current record's "Board" value
 * @method Seat        setGuest()           Sets the current record's "Guest" value
 * @method Seat        setSeat()            Sets the current record's "Seat" value
 * 
 * @package    balsit
 * @subpackage model
 * @author     Krzysiek Wesołowski
 * @version    SVN: $Id: Builder.php 6820 2009-11-30 17:27:49Z jwage $
 */
abstract class BaseSeat extends sfDoctrineRecord
{
    public function setTableDefinition()
    {
        $this->setTableName('seat');
        $this->hasColumn('board_id', 'integer', null, array(
             'type' => 'integer',
             'notnull' => true,
             ));
        $this->hasColumn('seller_id', 'integer', 4, array(
             'type' => 'integer',
             'notnull' => false,
             'length' => '4',
             ));
        $this->hasColumn('guest_id', 'integer', null, array(
             'type' => 'integer',
             'notnull' => false,
             ));
        $this->hasColumn('partner_seat_id', 'integer', null, array(
             'type' => 'integer',
             'notnull' => false,
             'unique' => true,
             ));
        $this->hasColumn('sold_time', 'timestamp', null, array(
             'type' => 'timestamp',
             'notnull' => false,
             ));
        $this->hasColumn('price', 'float', null, array(
             'type' => 'float',
             'notnull' => false,
             ));
        $this->hasColumn('comment', 'string', 1000, array(
             'type' => 'string',
             'notnull' => false,
             'length' => '1000',
             ));
        $this->hasColumn('sold', 'boolean', null, array(
             'type' => 'boolean',
             'default' => false,
             ));

        $this->option('type', 'INNODB');
        $this->option('collate', 'utf8_general_ci');
        $this->option('charset', 'utf8');
    }

    public function setUp()
    {
        parent::setUp();
        $this->hasOne('sfGuardUser', array(
             'local' => 'seller_id',
             'foreign' => 'id',
             'onDelete' => 'CASCADE'));

        $this->hasOne('Board', array(
             'local' => 'board_id',
             'foreign' => 'id',
             'onDelete' => 'CASCADE'));

        $this->hasOne('Guest', array(
             'local' => 'guest_id',
             'foreign' => 'id',
             'onDelete' => 'CASCADE'));

        $this->hasOne('Seat', array(
             'local' => 'partner_seat_id',
             'foreign' => 'id',
             'onDelete' => 'CASCADE'));
    }
}