
-- Copyright (c) Mark J. Kilgard, 1994, 1995, 1996, 1998.

-- This program is freely distributable without licensing fees  and is
-- provided without guarantee or warrantee expressed or  implied. This
-- program is -not- in the public domain.

--  modified for GNAT 3.11p/NT & Glut 3.7
--  Jerry van Dijk, 22-feb-99, jdijk@acm.org
--  use with accompanying DLL only
--
--  modified again for GNAT 3.14/NT & Glut 3.76
--  Gene Ressler, 22-jan-03, ressler@usma.edu
--  use with accompanying DLL only

package body Win32.Glut is

   pragma Linker_Options ("-lopengl32");
   pragma Linker_Options ("-lglu32");
   pragma Linker_Options ("-lglut32");

   procedure glutInitDisplayString(
      the_string : String
   )
   is
     C_the_string : Interfaces.C.Strings.Chars_Ptr
        := Interfaces.C.Strings.New_String(the_string);
   begin
     glutInitDisplayString(C_the_string);
     Interfaces.C.Strings.Free(C_the_string);
   end glutInitDisplayString;

   function glutCreateWindow(
      title : String
   ) return Integer
   is
     Rtn : Integer;
     C_title : Interfaces.C.Strings.Chars_Ptr
        := Interfaces.C.Strings.New_String(title);
   begin
     Rtn := glutCreateWindow(C_title);
     Interfaces.C.Strings.Free(C_title);
     return Rtn;
   end glutCreateWindow;

   procedure glutSetWindowTitle(
      title : String
   )
   is
     C_title : Interfaces.C.Strings.Chars_Ptr
        := Interfaces.C.Strings.New_String(title);
   begin
     glutSetWindowTitle(C_title);
     Interfaces.C.Strings.Free(C_title);
   end glutSetWindowTitle;

   procedure glutSetIconTitle(
      title : String
   )
   is
     C_title : Interfaces.C.Strings.Chars_Ptr
        := Interfaces.C.Strings.New_String(title);
   begin
     glutSetIconTitle(C_title);
     Interfaces.C.Strings.Free(C_title);
   end glutSetIconTitle;

   procedure glutAddMenuEntry(
      label : String;
      value : Integer
   )
   is
     C_label : Interfaces.C.Strings.Chars_Ptr
        := Interfaces.C.Strings.New_String(label);
   begin
     glutAddMenuEntry(C_label, value);
     Interfaces.C.Strings.Free(C_label);
   end glutAddMenuEntry;

   procedure glutAddSubMenu(
      label : String;
      submenu : Integer
   )
   is
     C_label : Interfaces.C.Strings.Chars_Ptr
        := Interfaces.C.Strings.New_String(label);
   begin
     glutAddSubMenu(C_label, submenu);
     Interfaces.C.Strings.Free(C_label);
   end glutAddSubMenu;

   procedure glutChangeToMenuEntry(
      item : Integer;
      label : String;
      value : Integer
   )
   is
     C_label : Interfaces.C.Strings.Chars_Ptr
        := Interfaces.C.Strings.New_String(label);
   begin
     glutChangeToMenuEntry(item, C_label, value);
     Interfaces.C.Strings.Free(C_label);
   end glutChangeToMenuEntry;

   procedure glutChangeToSubMenu(
      item : Integer;
      label : String;
      submenu : Integer
   )
   is
     C_label : Interfaces.C.Strings.Chars_Ptr
        := Interfaces.C.Strings.New_String(label);
   begin
     glutChangeToSubMenu(item, C_label, submenu);
     Interfaces.C.Strings.Free(C_label);
   end glutChangeToSubMenu;

   function glutExtensionSupported(
      name : String
   ) return Integer
   is
     Rtn : Integer;
     C_name : Interfaces.C.Strings.Chars_Ptr
        := Interfaces.C.Strings.New_String(name);
   begin
     Rtn := glutExtensionSupported(C_name);
     Interfaces.C.Strings.Free(C_name);
     return Rtn;
   end glutExtensionSupported;

   function glutBitmapLength(
      font : System.Address;
      the_string : String
   ) return Integer
   is
     Rtn : Integer;
     C_the_string : Interfaces.C.Strings.Chars_Ptr
        := Interfaces.C.Strings.New_String(the_string);
   begin
     Rtn := glutBitmapLength(font, C_the_string);
     Interfaces.C.Strings.Free(C_the_string);
     return Rtn;
   end glutBitmapLength;

   function glutStrokeLength(
      font : System.Address;
      the_string : String
   ) return Integer
   is
     Rtn : Integer;
     C_the_string : Interfaces.C.Strings.Chars_Ptr
        := Interfaces.C.Strings.New_String(the_string);
   begin
     Rtn := glutStrokeLength(font, C_the_string);
     Interfaces.C.Strings.Free(C_the_string);
     return Rtn;
   end glutStrokeLength;

   procedure glutGameModeString(
      the_string : String
   )
   is
     C_the_string : Interfaces.C.Strings.Chars_Ptr
        := Interfaces.C.Strings.New_String(the_string);
   begin
     glutGameModeString(C_the_string);
     Interfaces.C.Strings.Free(C_the_string);
   end glutGameModeString;
end Win32.Glut;
