
-- Copyright (c) Mark J. Kilgard, 1994, 1995, 1996, 1998.

-- This program is freely distributable without licensing fees  and is
-- provided without guarantee or warrantee expressed or  implied. This
-- program is -not- in the public domain.

--  modified for GNAT 3.11p/NT & Glut 3.7
--  Jerry van Dijk, 22-feb-99, jdijk@acm.org
--  use with accompanying DLL only
--
--  modified again for GNAT 3.14/NT & Glut 3.76
--  Gene Ressler, 22-jan-03, ressler@usma.edu
--  use with accompanying DLL only

with Win32.GL;
with Interfaces.C;
with Interfaces.C.Strings;
with System.Storage_Elements;

package Win32.Glut is

   package GL renames Win32.GL;


   --  Copyright (c) Mark J. Kilgard, 1994, 1995, 1996, 1998. 


   --  This program is freely distributable without licensing fees  and is
   --    provided without guarantee or warrantee expressed or  implied. This
   --    program is -not- in the public domain. 



   --  GLUT 3.7 now tries to avoid including <windows.h>
   --    to avoid name space pollution, but Win32's <GL/gl.h> 
   --    needs APIENTRY and WINGDIAPI defined properly. 

   --  XXX This is from Win32's <windef.h> 

   --  XXX This is from Win32's <winnt.h> 

   --  XXX Hack for lcc compiler.  It doesn't support __declspec(dllimport), just __stdcall. 

   --  XXX This is from Win32's <wingdi.h> and <winnt.h> 

   --  XXX This is from Win32's <ctype.h> 


   --  To disable automatic library usage for GLUT, define GLUT_NO_LIB_PRAGMA
   --    in your compile preprocessor options. 

   --  To enable automatic SGI OpenGL for Windows library usage for GLUT,
   --    define GLUT_USE_SGI_OPENGL in your compile preprocessor options.  


   --  To disable supression of annoying warnings about floats being promoted
   --    to doubles, define GLUT_NO_WARNING_DISABLE in your compile preprocessor
   --    options. 


   --  Win32 has an annoying issue where there are multiple C run-time
   --    libraries (CRTs).  If the executable is linked with a different CRT
   --    from the GLUT DLL, the GLUT DLL will not share the same CRT static
   --    data seen by the executable.  In particular, atexit callbacks registered
   --    in the executable will not be called if GLUT calls its (different)
   --    exit routine).  GLUT is typically built with the
   --    "/MD" option (the CRT with multithreading DLL support), but the Visual
   --    C++ linker default is "/ML" (the single threaded CRT).
   -- 
   --    One workaround to this issue is requiring users to always link with
   --    the same CRT as GLUT is compiled with.  That requires users supply a
   --    non-standard option.  GLUT 3.7 has its own built-in workaround where
   --    the executable's "exit" function pointer is covertly passed to GLUT.
   --    GLUT then calls the executable's exit function pointer to ensure that
   --    any "atexit" calls registered by the application are called if GLUT
   --    needs to exit.
   -- 
   --    Note that the __glut*WithExit routines should NEVER be called directly.
   --    To avoid the atexit workaround, #define GLUT_DISABLE_ATEXIT_HACK. 


   --  XXX This is from Win32's <process.h> 

   --  Current definition 


   --  GLUT API entry point declarations for Win32. 


   --  GLUT callback calling convention for Win32. 






   -- *
   --  GLUT API revision history:
   --  
   --  GLUT_API_VERSION is updated to reflect incompatible GLUT
   --  API changes (interface changes, semantic changes, deletions,
   --  or additions).
   --  
   --  GLUT_API_VERSION=1  First public release of GLUT.  11/29/94
   -- 
   --  GLUT_API_VERSION=2  Added support for OpenGL/GLX multisampling,
   --  extension.  Supports new input devices like tablet, dial and button
   --  box, and Spaceball.  Easy to query OpenGL extensions.
   -- 
   --  GLUT_API_VERSION=3  glutMenuStatus added.
   -- 
   --  GLUT_API_VERSION=4  glutInitDisplayString, glutWarpPointer,
   --  glutBitmapLength, glutStrokeLength, glutWindowStatusFunc, dynamic
   --  video resize subAPI, glutPostWindowRedisplay, glutKeyboardUpFunc,
   --  glutSpecialUpFunc, glutIgnoreKeyRepeat, glutSetKeyRepeat,
   --  glutJoystickFunc, glutForceJoystickFunc (NOT FINALIZED!).
   -- *


   -- *
   --  GLUT implementation revision history:
   --  
   --  GLUT_XLIB_IMPLEMENTATION is updated to reflect both GLUT
   --  API revisions and implementation revisions (ie, bug fixes).
   -- 
   --  GLUT_XLIB_IMPLEMENTATION=1  mjk's first public release of
   --  GLUT Xlib-based implementation.  11/29/94
   -- 
   --  GLUT_XLIB_IMPLEMENTATION=2  mjk's second public release of
   --  GLUT Xlib-based implementation providing GLUT version 2 
   --  interfaces.
   -- 
   --  GLUT_XLIB_IMPLEMENTATION=3  mjk's GLUT 2.2 images. 4/17/95
   -- 
   --  GLUT_XLIB_IMPLEMENTATION=4  mjk's GLUT 2.3 images. 6/?/95
   -- 
   --  GLUT_XLIB_IMPLEMENTATION=5  mjk's GLUT 3.0 images. 10/?/95
   -- 
   --  GLUT_XLIB_IMPLEMENTATION=7  mjk's GLUT 3.1+ with glutWarpPoitner.  7/24/96
   -- 
   --  GLUT_XLIB_IMPLEMENTATION=8  mjk's GLUT 3.1+ with glutWarpPoitner
   --  and video resize.  1/3/97
   -- 
   --  GLUT_XLIB_IMPLEMENTATION=9 mjk's GLUT 3.4 release with early GLUT 4 routines.
   -- 
   --  GLUT_XLIB_IMPLEMENTATION=11 Mesa 2.5's GLUT 3.6 release.
   -- 
   --  GLUT_XLIB_IMPLEMENTATION=12 mjk's GLUT 3.6 release with early GLUT 4 routines + signal handling.
   -- 
   --  GLUT_XLIB_IMPLEMENTATION=13 mjk's GLUT 3.7 beta with GameGLUT support.
   -- 
   --  GLUT_XLIB_IMPLEMENTATION=14 mjk's GLUT 3.7 beta with f90gl friend interface.
   -- 
   --  GLUT_XLIB_IMPLEMENTATION=15 mjk's GLUT 3.7 beta sync'ed with Mesa <GL/glut.h>
   -- *

   GLUT_XLIB_IMPLEMENTATION             : constant := 15; --  glut.h:223

   --  Display mode bit masks. 

   GLUT_RGB                             : constant := 0; --  glut.h:227
   GLUT_RGBA                            : constant := GLUT_RGB; --  glut.h:228
   GLUT_INDEX                           : constant := 1; --  glut.h:229
   GLUT_SINGLE                          : constant := 0; --  glut.h:230
   GLUT_DOUBLE                          : constant := 2; --  glut.h:231
   GLUT_ACCUM                           : constant := 4; --  glut.h:232
   GLUT_ALPHA                           : constant := 8; --  glut.h:233
   GLUT_DEPTH                           : constant := 16; --  glut.h:234
   GLUT_STENCIL                         : constant := 32; --  glut.h:235
   GLUT_MULTISAMPLE                     : constant := 128; --  glut.h:237
   GLUT_STEREO                          : constant := 256; --  glut.h:238
   GLUT_LUMINANCE                       : constant := 512; --  glut.h:241

   --  Mouse buttons. 

   GLUT_LEFT_BUTTON                     : constant := 0; --  glut.h:245
   GLUT_MIDDLE_BUTTON                   : constant := 1; --  glut.h:246
   GLUT_RIGHT_BUTTON                    : constant := 2; --  glut.h:247

   --  Mouse button  state. 

   GLUT_DOWN                            : constant := 0; --  glut.h:250
   GLUT_UP                              : constant := 1; --  glut.h:251

   --  function keys 

   GLUT_KEY_F1                          : constant := 1; --  glut.h:255
   GLUT_KEY_F2                          : constant := 2; --  glut.h:256
   GLUT_KEY_F3                          : constant := 3; --  glut.h:257
   GLUT_KEY_F4                          : constant := 4; --  glut.h:258
   GLUT_KEY_F5                          : constant := 5; --  glut.h:259
   GLUT_KEY_F6                          : constant := 6; --  glut.h:260
   GLUT_KEY_F7                          : constant := 7; --  glut.h:261
   GLUT_KEY_F8                          : constant := 8; --  glut.h:262
   GLUT_KEY_F9                          : constant := 9; --  glut.h:263
   GLUT_KEY_F10                         : constant := 10; --  glut.h:264
   GLUT_KEY_F11                         : constant := 11; --  glut.h:265
   GLUT_KEY_F12                         : constant := 12; --  glut.h:266
   --  directional keys 

   GLUT_KEY_LEFT                        : constant := 100; --  glut.h:268
   GLUT_KEY_UP                          : constant := 101; --  glut.h:269
   GLUT_KEY_RIGHT                       : constant := 102; --  glut.h:270
   GLUT_KEY_DOWN                        : constant := 103; --  glut.h:271
   GLUT_KEY_PAGE_UP                     : constant := 104; --  glut.h:272
   GLUT_KEY_PAGE_DOWN                   : constant := 105; --  glut.h:273
   GLUT_KEY_HOME                        : constant := 106; --  glut.h:274
   GLUT_KEY_END                         : constant := 107; --  glut.h:275
   GLUT_KEY_INSERT                      : constant := 108; --  glut.h:276

   --  Entry/exit  state. 

   GLUT_LEFT                            : constant := 0; --  glut.h:280
   GLUT_ENTERED                         : constant := 1; --  glut.h:281

   --  Menu usage  state. 

   GLUT_MENU_NOT_IN_USE                 : constant := 0; --  glut.h:284
   GLUT_MENU_IN_USE                     : constant := 1; --  glut.h:285

   --  Visibility  state. 

   GLUT_NOT_VISIBLE                     : constant := 0; --  glut.h:288
   GLUT_VISIBLE                         : constant := 1; --  glut.h:289

   --  Window status  state. 

   GLUT_HIDDEN                          : constant := 0; --  glut.h:292
   GLUT_FULLY_RETAINED                  : constant := 1; --  glut.h:293
   GLUT_PARTIALLY_RETAINED              : constant := 2; --  glut.h:294
   GLUT_FULLY_COVERED                   : constant := 3; --  glut.h:295

   --  Color index component selection values. 

   GLUT_RED                             : constant := 0; --  glut.h:298
   GLUT_GREEN                           : constant := 1; --  glut.h:299
   GLUT_BLUE                            : constant := 2; --  glut.h:300

   --  Stroke font constants (use these in GLUT program). 

   GLUT_STROKE_ROMAN                    : constant  System.Address
     := System.Storage_elements.To_Address(0); --  glut.h:304
   GLUT_STROKE_MONO_ROMAN               : constant  System.Address
     := System.Storage_elements.To_Address(1); --  glut.h:305

   --  Bitmap font constants (use these in GLUT program). 

   GLUT_BITMAP_9_BY_15                  : constant  System.Address
     := System.Storage_elements.To_Address(2); --  glut.h:308
   GLUT_BITMAP_8_BY_13                  : constant  System.Address
     := System.Storage_elements.To_Address(3); --  glut.h:309
   GLUT_BITMAP_TIMES_ROMAN_10           : constant  System.Address
     := System.Storage_elements.To_Address(4); --  glut.h:310
   GLUT_BITMAP_TIMES_ROMAN_24           : constant  System.Address
     := System.Storage_elements.To_Address(5); --  glut.h:311
   GLUT_BITMAP_HELVETICA_10             : constant  System.Address
     := System.Storage_elements.To_Address(6); --  glut.h:313
   GLUT_BITMAP_HELVETICA_12             : constant  System.Address
     := System.Storage_elements.To_Address(7); --  glut.h:314
   GLUT_BITMAP_HELVETICA_18             : constant  System.Address
     := System.Storage_elements.To_Address(8); --  glut.h:315

   --  glutGet parameters. 

   GLUT_WINDOW_X                        : constant := 100; --  glut.h:348
   GLUT_WINDOW_Y                        : constant := 101; --  glut.h:349
   GLUT_WINDOW_WIDTH                    : constant := 102; --  glut.h:350
   GLUT_WINDOW_HEIGHT                   : constant := 103; --  glut.h:351
   GLUT_WINDOW_BUFFER_SIZE              : constant := 104; --  glut.h:352
   GLUT_WINDOW_STENCIL_SIZE             : constant := 105; --  glut.h:353
   GLUT_WINDOW_DEPTH_SIZE               : constant := 106; --  glut.h:354
   GLUT_WINDOW_RED_SIZE                 : constant := 107; --  glut.h:355
   GLUT_WINDOW_GREEN_SIZE               : constant := 108; --  glut.h:356
   GLUT_WINDOW_BLUE_SIZE                : constant := 109; --  glut.h:357
   GLUT_WINDOW_ALPHA_SIZE               : constant := 110; --  glut.h:358
   GLUT_WINDOW_ACCUM_RED_SIZE           : constant := 111; --  glut.h:359
   GLUT_WINDOW_ACCUM_GREEN_SIZE         : constant := 112; --  glut.h:360
   GLUT_WINDOW_ACCUM_BLUE_SIZE          : constant := 113; --  glut.h:361
   GLUT_WINDOW_ACCUM_ALPHA_SIZE         : constant := 114; --  glut.h:362
   GLUT_WINDOW_DOUBLEBUFFER             : constant := 115; --  glut.h:363
   GLUT_WINDOW_RGBA                     : constant := 116; --  glut.h:364
   GLUT_WINDOW_PARENT                   : constant := 117; --  glut.h:365
   GLUT_WINDOW_NUM_CHILDREN             : constant := 118; --  glut.h:366
   GLUT_WINDOW_COLORMAP_SIZE            : constant := 119; --  glut.h:367
   GLUT_WINDOW_NUM_SAMPLES              : constant := 120; --  glut.h:369
   GLUT_WINDOW_STEREO                   : constant := 121; --  glut.h:370
   GLUT_WINDOW_CURSOR                   : constant := 122; --  glut.h:373
   GLUT_SCREEN_WIDTH                    : constant := 200; --  glut.h:375
   GLUT_SCREEN_HEIGHT                   : constant := 201; --  glut.h:376
   GLUT_SCREEN_WIDTH_MM                 : constant := 202; --  glut.h:377
   GLUT_SCREEN_HEIGHT_MM                : constant := 203; --  glut.h:378
   GLUT_MENU_NUM_ITEMS                  : constant := 300; --  glut.h:379
   GLUT_DISPLAY_MODE_POSSIBLE           : constant := 400; --  glut.h:380
   GLUT_INIT_WINDOW_X                   : constant := 500; --  glut.h:381
   GLUT_INIT_WINDOW_Y                   : constant := 501; --  glut.h:382
   GLUT_INIT_WINDOW_WIDTH               : constant := 502; --  glut.h:383
   GLUT_INIT_WINDOW_HEIGHT              : constant := 503; --  glut.h:384
   GLUT_INIT_DISPLAY_MODE               : constant := 504; --  glut.h:385
   GLUT_ELAPSED_TIME                    : constant := 700; --  glut.h:387
   GLUT_WINDOW_FORMAT_ID                : constant := 123; --  glut.h:390

   --  glutDeviceGet parameters. 

   GLUT_HAS_KEYBOARD                    : constant := 600; --  glut.h:395
   GLUT_HAS_MOUSE                       : constant := 601; --  glut.h:396
   GLUT_HAS_SPACEBALL                   : constant := 602; --  glut.h:397
   GLUT_HAS_DIAL_AND_BUTTON_BOX         : constant := 603; --  glut.h:398
   GLUT_HAS_TABLET                      : constant := 604; --  glut.h:399
   GLUT_NUM_MOUSE_BUTTONS               : constant := 605; --  glut.h:400
   GLUT_NUM_SPACEBALL_BUTTONS           : constant := 606; --  glut.h:401
   GLUT_NUM_BUTTON_BOX_BUTTONS          : constant := 607; --  glut.h:402
   GLUT_NUM_DIALS                       : constant := 608; --  glut.h:403
   GLUT_NUM_TABLET_BUTTONS              : constant := 609; --  glut.h:404
   GLUT_DEVICE_IGNORE_KEY_REPEAT        : constant := 610; --  glut.h:407
   GLUT_DEVICE_KEY_REPEAT               : constant := 611; --  glut.h:408
   GLUT_HAS_JOYSTICK                    : constant := 612; --  glut.h:409
   GLUT_OWNS_JOYSTICK                   : constant := 613; --  glut.h:410
   GLUT_JOYSTICK_BUTTONS                : constant := 614; --  glut.h:411
   GLUT_JOYSTICK_AXES                   : constant := 615; --  glut.h:412
   GLUT_JOYSTICK_POLL_RATE              : constant := 616; --  glut.h:413

   --  glutLayerGet parameters. 

   GLUT_OVERLAY_POSSIBLE                : constant := 800; --  glut.h:418
   GLUT_LAYER_IN_USE                    : constant := 801; --  glut.h:419
   GLUT_HAS_OVERLAY                     : constant := 802; --  glut.h:420
   GLUT_TRANSPARENT_INDEX               : constant := 803; --  glut.h:421
   GLUT_NORMAL_DAMAGED                  : constant := 804; --  glut.h:422
   GLUT_OVERLAY_DAMAGED                 : constant := 805; --  glut.h:423

   --  glutVideoResizeGet parameters. 

   GLUT_VIDEO_RESIZE_POSSIBLE           : constant := 900; --  glut.h:427
   GLUT_VIDEO_RESIZE_IN_USE             : constant := 901; --  glut.h:428
   GLUT_VIDEO_RESIZE_X_DELTA            : constant := 902; --  glut.h:429
   GLUT_VIDEO_RESIZE_Y_DELTA            : constant := 903; --  glut.h:430
   GLUT_VIDEO_RESIZE_WIDTH_DELTA        : constant := 904; --  glut.h:431
   GLUT_VIDEO_RESIZE_HEIGHT_DELTA       : constant := 905; --  glut.h:432
   GLUT_VIDEO_RESIZE_X                  : constant := 906; --  glut.h:433
   GLUT_VIDEO_RESIZE_Y                  : constant := 907; --  glut.h:434
   GLUT_VIDEO_RESIZE_WIDTH              : constant := 908; --  glut.h:435
   GLUT_VIDEO_RESIZE_HEIGHT             : constant := 909; --  glut.h:436

   --  glutUseLayer parameters. 

   GLUT_NORMAL                          : constant := 0; --  glut.h:440
   GLUT_OVERLAY                         : constant := 1; --  glut.h:441

   --  glutGetModifiers return mask. 

   GLUT_ACTIVE_SHIFT                    : constant := 1; --  glut.h:444
   GLUT_ACTIVE_CTRL                     : constant := 2; --  glut.h:445
   GLUT_ACTIVE_ALT                      : constant := 4; --  glut.h:446

   --  glutSetCursor parameters. 

   --  Basic arrows. 

   GLUT_CURSOR_RIGHT_ARROW              : constant := 0; --  glut.h:450
   GLUT_CURSOR_LEFT_ARROW               : constant := 1; --  glut.h:451
   --  Symbolic cursor shapes. 

   GLUT_CURSOR_INFO                     : constant := 2; --  glut.h:453
   GLUT_CURSOR_DESTROY                  : constant := 3; --  glut.h:454
   GLUT_CURSOR_HELP                     : constant := 4; --  glut.h:455
   GLUT_CURSOR_CYCLE                    : constant := 5; --  glut.h:456
   GLUT_CURSOR_SPRAY                    : constant := 6; --  glut.h:457
   GLUT_CURSOR_WAIT                     : constant := 7; --  glut.h:458
   GLUT_CURSOR_TEXT                     : constant := 8; --  glut.h:459
   GLUT_CURSOR_CROSSHAIR                : constant := 9; --  glut.h:460
   --  Directional cursors. 

   GLUT_CURSOR_UP_DOWN                  : constant := 10; --  glut.h:462
   GLUT_CURSOR_LEFT_RIGHT               : constant := 11; --  glut.h:463
   --  Sizing cursors. 

   GLUT_CURSOR_TOP_SIDE                 : constant := 12; --  glut.h:465
   GLUT_CURSOR_BOTTOM_SIDE              : constant := 13; --  glut.h:466
   GLUT_CURSOR_LEFT_SIDE                : constant := 14; --  glut.h:467
   GLUT_CURSOR_RIGHT_SIDE               : constant := 15; --  glut.h:468
   GLUT_CURSOR_TOP_LEFT_CORNER          : constant := 16; --  glut.h:469
   GLUT_CURSOR_TOP_RIGHT_CORNER         : constant := 17; --  glut.h:470
   GLUT_CURSOR_BOTTOM_RIGHT_CORNER      : constant := 18; --  glut.h:471
   GLUT_CURSOR_BOTTOM_LEFT_CORNER       : constant := 19; --  glut.h:472
   --  Inherit from parent window. 

   GLUT_CURSOR_INHERIT                  : constant := 100; --  glut.h:474
   --  Blank cursor. 

   GLUT_CURSOR_NONE                     : constant := 101; --  glut.h:476
   --  Fullscreen crosshair (if available). 

   GLUT_CURSOR_FULL_CROSSHAIR           : constant := 102; --  glut.h:478

   --  GLUT initialization sub-API. 


   procedure glutInit(
      argcp : access Integer;
      argv : access Interfaces.C.Strings.Chars_Ptr
   ); --  glut.h:482
   pragma Import (Stdcall, glutInit, "glutInit");

   procedure glutInitDisplayMode(
      mode : Interfaces.C.unsigned
   ); --  glut.h:490
   pragma Import (Stdcall, glutInitDisplayMode, "glutInitDisplayMode");

   procedure glutInitDisplayString(
      the_string : Interfaces.C.Strings.Chars_Ptr
   ); --  glut.h:492
   pragma Import (Stdcall, glutInitDisplayString, "glutInitDisplayString");

   procedure glutInitDisplayString(
      the_string : String
   ); --  glut.h:492

   procedure glutInitWindowPosition(
      x : Integer;
      y : Integer
   ); --  glut.h:494
   pragma Import (Stdcall, glutInitWindowPosition, "glutInitWindowPosition");

   procedure glutInitWindowSize(
      width : Integer;
      height : Integer
   ); --  glut.h:495
   pragma Import (Stdcall, glutInitWindowSize, "glutInitWindowSize");

   procedure glutMainLoop; --  gl.h:496
   pragma Import (Stdcall, glutMainLoop, "glutMainLoop");

   --  GLUT window sub-API. 


   function glutCreateWindow(
      title : Interfaces.C.Strings.Chars_Ptr
   ) return Integer; --  glut.h:499
   pragma Import (Stdcall, glutCreateWindow, "glutCreateWindow");

   function glutCreateWindow(
      title : String
   ) return Integer; --  glut.h:499

   function glutCreateSubWindow(
      win : Integer;
      x : Integer;
      y : Integer;
      width : Integer;
      height : Integer
   ) return Integer; --  glut.h:507
   pragma Import (Stdcall, glutCreateSubWindow, "glutCreateSubWindow");

   procedure glutDestroyWindow(
      win : Integer
   ); --  glut.h:508
   pragma Import (Stdcall, glutDestroyWindow, "glutDestroyWindow");

   procedure glutPostRedisplay; --  gl.h:509
   pragma Import (Stdcall, glutPostRedisplay, "glutPostRedisplay");

   procedure glutPostWindowRedisplay(
      win : Integer
   ); --  glut.h:511
   pragma Import (Stdcall, glutPostWindowRedisplay, "glutPostWindowRedisplay");

   procedure glutSwapBuffers; --  gl.h:513
   pragma Import (Stdcall, glutSwapBuffers, "glutSwapBuffers");
   function glutGetWindow return Integer; --  gl.h:514
   pragma Import (Stdcall, glutGetWindow, "glutGetWindow");

   procedure glutSetWindow(
      win : Integer
   ); --  glut.h:515
   pragma Import (Stdcall, glutSetWindow, "glutSetWindow");

   procedure glutSetWindowTitle(
      title : Interfaces.C.Strings.Chars_Ptr
   ); --  glut.h:516
   pragma Import (Stdcall, glutSetWindowTitle, "glutSetWindowTitle");

   procedure glutSetWindowTitle(
      title : String
   ); --  glut.h:516

   procedure glutSetIconTitle(
      title : Interfaces.C.Strings.Chars_Ptr
   ); --  glut.h:517
   pragma Import (Stdcall, glutSetIconTitle, "glutSetIconTitle");

   procedure glutSetIconTitle(
      title : String
   ); --  glut.h:517

   procedure glutPositionWindow(
      x : Integer;
      y : Integer
   ); --  glut.h:518
   pragma Import (Stdcall, glutPositionWindow, "glutPositionWindow");

   procedure glutReshapeWindow(
      width : Integer;
      height : Integer
   ); --  glut.h:519
   pragma Import (Stdcall, glutReshapeWindow, "glutReshapeWindow");

   procedure glutPopWindow; --  gl.h:520
   pragma Import (Stdcall, glutPopWindow, "glutPopWindow");

   procedure glutPushWindow; --  gl.h:521
   pragma Import (Stdcall, glutPushWindow, "glutPushWindow");

   procedure glutIconifyWindow; --  gl.h:522
   pragma Import (Stdcall, glutIconifyWindow, "glutIconifyWindow");

   procedure glutShowWindow; --  gl.h:523
   pragma Import (Stdcall, glutShowWindow, "glutShowWindow");

   procedure glutHideWindow; --  gl.h:524
   pragma Import (Stdcall, glutHideWindow, "glutHideWindow");

   procedure glutFullScreen; --  gl.h:526
   pragma Import (Stdcall, glutFullScreen, "glutFullScreen");

   procedure glutSetCursor(
      cursor : Integer
   ); --  glut.h:527
   pragma Import (Stdcall, glutSetCursor, "glutSetCursor");

   procedure glutWarpPointer(
      x : Integer;
      y : Integer
   ); --  glut.h:529
   pragma Import (Stdcall, glutWarpPointer, "glutWarpPointer");

   --  GLUT overlay sub-API. 


   procedure glutEstablishOverlay; --  gl.h:533
   pragma Import (Stdcall, glutEstablishOverlay, "glutEstablishOverlay");

   procedure glutRemoveOverlay; --  gl.h:534
   pragma Import (Stdcall, glutRemoveOverlay, "glutRemoveOverlay");

   procedure glutUseLayer(
      layer : GL.GLenum
   ); --  glut.h:535
   pragma Import (Stdcall, glutUseLayer, "glutUseLayer");

   procedure glutPostOverlayRedisplay; --  gl.h:536
   pragma Import (Stdcall, glutPostOverlayRedisplay, "glutPostOverlayRedisplay");

   procedure glutPostWindowOverlayRedisplay(
      win : Integer
   ); --  glut.h:538
   pragma Import (Stdcall, glutPostWindowOverlayRedisplay, "glutPostWindowOverlayRedisplay");

   procedure glutShowOverlay; --  gl.h:540
   pragma Import (Stdcall, glutShowOverlay, "glutShowOverlay");

   procedure glutHideOverlay; --  gl.h:541
   pragma Import (Stdcall, glutHideOverlay, "glutHideOverlay");

   --  GLUT menu sub-API. 


   type glutCreateMenu_Type is access procedure (
      t01 : Integer
   );
   function glutCreateMenu(
      func : glutCreateMenu_Type
   ) return Integer; --  glut.h:545
   pragma Import (Stdcall, glutCreateMenu, "glutCreateMenu");

   procedure glutDestroyMenu(
      menu : Integer
   ); --  glut.h:553
   pragma Import (Stdcall, glutDestroyMenu, "glutDestroyMenu");
   function glutGetMenu return Integer; --  gl.h:554
   pragma Import (Stdcall, glutGetMenu, "glutGetMenu");

   procedure glutSetMenu(
      menu : Integer
   ); --  glut.h:555
   pragma Import (Stdcall, glutSetMenu, "glutSetMenu");

   procedure glutAddMenuEntry(
      label : Interfaces.C.Strings.Chars_Ptr;
      value : Integer
   ); --  glut.h:556
   pragma Import (Stdcall, glutAddMenuEntry, "glutAddMenuEntry");

   procedure glutAddMenuEntry(
      label : String;
      value : Integer
   ); --  glut.h:556

   procedure glutAddSubMenu(
      label : Interfaces.C.Strings.Chars_Ptr;
      submenu : Integer
   ); --  glut.h:557
   pragma Import (Stdcall, glutAddSubMenu, "glutAddSubMenu");

   procedure glutAddSubMenu(
      label : String;
      submenu : Integer
   ); --  glut.h:557

   procedure glutChangeToMenuEntry(
      item : Integer;
      label : Interfaces.C.Strings.Chars_Ptr;
      value : Integer
   ); --  glut.h:558
   pragma Import (Stdcall, glutChangeToMenuEntry, "glutChangeToMenuEntry");

   procedure glutChangeToMenuEntry(
      item : Integer;
      label : String;
      value : Integer
   ); --  glut.h:558

   procedure glutChangeToSubMenu(
      item : Integer;
      label : Interfaces.C.Strings.Chars_Ptr;
      submenu : Integer
   ); --  glut.h:559
   pragma Import (Stdcall, glutChangeToSubMenu, "glutChangeToSubMenu");

   procedure glutChangeToSubMenu(
      item : Integer;
      label : String;
      submenu : Integer
   ); --  glut.h:559

   procedure glutRemoveMenuItem(
      item : Integer
   ); --  glut.h:560
   pragma Import (Stdcall, glutRemoveMenuItem, "glutRemoveMenuItem");

   procedure glutAttachMenu(
      button : Integer
   ); --  glut.h:561
   pragma Import (Stdcall, glutAttachMenu, "glutAttachMenu");

   procedure glutDetachMenu(
      button : Integer
   ); --  glut.h:562
   pragma Import (Stdcall, glutDetachMenu, "glutDetachMenu");

   --  GLUT window callback sub-API. 


   type glutDisplayFunc_Type is access procedure;

   procedure glutDisplayFunc(
      func : glutDisplayFunc_Type
   ); --  glut.h:565
   pragma Import (Stdcall, glutDisplayFunc, "glutDisplayFunc");

   type glutReshapeFunc_Type is access procedure (
      width : Integer;
      height : Integer
   );
   procedure glutReshapeFunc(
      func : glutReshapeFunc_Type
   ); --  glut.h:566
   pragma Import (Stdcall, glutReshapeFunc, "glutReshapeFunc");

   type glutKeyboardFunc_Type is access procedure (
      key : Interfaces.C.unsigned_char;
      x : Integer;
      y : Integer
   );
   procedure glutKeyboardFunc(
      func : glutKeyboardFunc_Type
   ); --  glut.h:567
   pragma Import (Stdcall, glutKeyboardFunc, "glutKeyboardFunc");

   type glutMouseFunc_Type is access procedure (
      button : Integer;
      state : Integer;
      x : Integer;
      y : Integer
   );
   procedure glutMouseFunc(
      func : glutMouseFunc_Type
   ); --  glut.h:568
   pragma Import (Stdcall, glutMouseFunc, "glutMouseFunc");

   type glutMotionFunc_Type is access procedure (
      x : Integer;
      y : Integer
   );
   procedure glutMotionFunc(
      func : glutMotionFunc_Type
   ); --  glut.h:569
   pragma Import (Stdcall, glutMotionFunc, "glutMotionFunc");

   type glutPassiveMotionFunc_Type is access procedure (
      x : Integer;
      y : Integer
   );
   procedure glutPassiveMotionFunc(
      func : glutPassiveMotionFunc_Type
   ); --  glut.h:570
   pragma Import (Stdcall, glutPassiveMotionFunc, "glutPassiveMotionFunc");

   type glutEntryFunc_Type is access procedure (
      state : Integer
   );
   procedure glutEntryFunc(
      func : glutEntryFunc_Type
   ); --  glut.h:571
   pragma Import (Stdcall, glutEntryFunc, "glutEntryFunc");

   type glutVisibilityFunc_Type is access procedure (
      state : Integer
   );
   procedure glutVisibilityFunc(
      func : glutVisibilityFunc_Type
   ); --  glut.h:572
   pragma Import (Stdcall, glutVisibilityFunc, "glutVisibilityFunc");

   type glutIdleFunc_Type is access procedure;

   procedure glutIdleFunc(
      func : glutIdleFunc_Type
   ); --  glut.h:573
   pragma Import (Stdcall, glutIdleFunc, "glutIdleFunc");

   type glutTimerFunc_Type is access procedure (
      value : Integer
   );
   procedure glutTimerFunc(
      millis : Interfaces.C.unsigned;
      func : glutTimerFunc_Type;
      value : Integer
   ); --  glut.h:574
   pragma Import (Stdcall, glutTimerFunc, "glutTimerFunc");

   type glutMenuStateFunc_Type is access procedure (
      state : Integer
   );
   procedure glutMenuStateFunc(
      func : glutMenuStateFunc_Type
   ); --  glut.h:575
   pragma Import (Stdcall, glutMenuStateFunc, "glutMenuStateFunc");

   type glutSpecialFunc_Type is access procedure (
      key : Integer;
      x : Integer;
      y : Integer
   );
   procedure glutSpecialFunc(
      func : glutSpecialFunc_Type
   ); --  glut.h:577
   pragma Import (Stdcall, glutSpecialFunc, "glutSpecialFunc");

   type glutSpaceballMotionFunc_Type is access procedure (
      x : Integer;
      y : Integer;
      z : Integer
   );
   procedure glutSpaceballMotionFunc(
      func : glutSpaceballMotionFunc_Type
   ); --  glut.h:578
   pragma Import (Stdcall, glutSpaceballMotionFunc, "glutSpaceballMotionFunc");

   type glutSpaceballRotateFunc_Type is access procedure (
      x : Integer;
      y : Integer;
      z : Integer
   );
   procedure glutSpaceballRotateFunc(
      func : glutSpaceballRotateFunc_Type
   ); --  glut.h:579
   pragma Import (Stdcall, glutSpaceballRotateFunc, "glutSpaceballRotateFunc");

   type glutSpaceballButtonFunc_Type is access procedure (
      button : Integer;
      state : Integer
   );
   procedure glutSpaceballButtonFunc(
      func : glutSpaceballButtonFunc_Type
   ); --  glut.h:580
   pragma Import (Stdcall, glutSpaceballButtonFunc, "glutSpaceballButtonFunc");

   type glutButtonBoxFunc_Type is access procedure (
      button : Integer;
      state : Integer
   );
   procedure glutButtonBoxFunc(
      func : glutButtonBoxFunc_Type
   ); --  glut.h:581
   pragma Import (Stdcall, glutButtonBoxFunc, "glutButtonBoxFunc");

   type glutDialsFunc_Type is access procedure (
      dial : Integer;
      value : Integer
   );
   procedure glutDialsFunc(
      func : glutDialsFunc_Type
   ); --  glut.h:582
   pragma Import (Stdcall, glutDialsFunc, "glutDialsFunc");

   type glutTabletMotionFunc_Type is access procedure (
      x : Integer;
      y : Integer
   );
   procedure glutTabletMotionFunc(
      func : glutTabletMotionFunc_Type
   ); --  glut.h:583
   pragma Import (Stdcall, glutTabletMotionFunc, "glutTabletMotionFunc");

   type glutTabletButtonFunc_Type is access procedure (
      button : Integer;
      state : Integer;
      x : Integer;
      y : Integer
   );
   procedure glutTabletButtonFunc(
      func : glutTabletButtonFunc_Type
   ); --  glut.h:584
   pragma Import (Stdcall, glutTabletButtonFunc, "glutTabletButtonFunc");

   type glutMenuStatusFunc_Type is access procedure (
      status : Integer;
      x : Integer;
      y : Integer
   );
   procedure glutMenuStatusFunc(
      func : glutMenuStatusFunc_Type
   ); --  glut.h:586
   pragma Import (Stdcall, glutMenuStatusFunc, "glutMenuStatusFunc");

   type glutOverlayDisplayFunc_Type is access procedure;

   procedure glutOverlayDisplayFunc(
      func : glutOverlayDisplayFunc_Type
   ); --  glut.h:587
   pragma Import (Stdcall, glutOverlayDisplayFunc, "glutOverlayDisplayFunc");

   type glutWindowStatusFunc_Type is access procedure (
      state : Integer
   );
   procedure glutWindowStatusFunc(
      func : glutWindowStatusFunc_Type
   ); --  glut.h:589
   pragma Import (Stdcall, glutWindowStatusFunc, "glutWindowStatusFunc");

   type glutKeyboardUpFunc_Type is access procedure (
      key : Interfaces.C.unsigned_char;
      x : Integer;
      y : Integer
   );
   procedure glutKeyboardUpFunc(
      func : glutKeyboardUpFunc_Type
   ); --  glut.h:592
   pragma Import (Stdcall, glutKeyboardUpFunc, "glutKeyboardUpFunc");

   type glutSpecialUpFunc_Type is access procedure (
      key : Integer;
      x : Integer;
      y : Integer
   );
   procedure glutSpecialUpFunc(
      func : glutSpecialUpFunc_Type
   ); --  glut.h:593
   pragma Import (Stdcall, glutSpecialUpFunc, "glutSpecialUpFunc");

   type glutJoystickFunc_Type is access procedure (
      buttonMask : Interfaces.C.unsigned;
      x : Integer;
      y : Integer;
      z : Integer
   );
   procedure glutJoystickFunc(
      func : glutJoystickFunc_Type;
      pollInterval : Integer
   ); --  glut.h:594
   pragma Import (Stdcall, glutJoystickFunc, "glutJoystickFunc");

   --  GLUT color index sub-API. 


   procedure glutSetColor(
      t02 : Integer;
      red : GL.GLfloat;
      green : GL.GLfloat;
      blue : GL.GLfloat
   ); --  glut.h:600
   pragma Import (Stdcall, glutSetColor, "glutSetColor");

   function glutGetColor(
      ndx : Integer;
      component : Integer
   ) return GL.GLfloat; --  glut.h:601
   pragma Import (Stdcall, glutGetColor, "glutGetColor");

   procedure glutCopyColormap(
      win : Integer
   ); --  glut.h:602
   pragma Import (Stdcall, glutCopyColormap, "glutCopyColormap");

   --  GLUT state retrieval sub-API. 


   function glutGet(
      the_type : GL.GLenum
   ) return Integer; --  glut.h:605
   pragma Import (Stdcall, glutGet, "glutGet");

   function glutDeviceGet(
      the_type : GL.GLenum
   ) return Integer; --  glut.h:606
   pragma Import (Stdcall, glutDeviceGet, "glutDeviceGet");
   --  GLUT extension support sub-API 


   function glutExtensionSupported(
      name : Interfaces.C.Strings.Chars_Ptr
   ) return Integer; --  glut.h:609
   pragma Import (Stdcall, glutExtensionSupported, "glutExtensionSupported");

   function glutExtensionSupported(
      name : String
   ) return Integer; --  glut.h:609
   function glutGetModifiers return Integer; --  gl.h:612
   pragma Import (Stdcall, glutGetModifiers, "glutGetModifiers");

   function glutLayerGet(
      the_type : GL.GLenum
   ) return Integer; --  glut.h:613
   pragma Import (Stdcall, glutLayerGet, "glutLayerGet");

   --  GLUT font sub-API 


   procedure glutBitmapCharacter(
      font : System.Address;
      character : Integer
   ); --  glut.h:617
   pragma Import (Stdcall, glutBitmapCharacter, "glutBitmapCharacter");

   function glutBitmapWidth(
      font : System.Address;
      character : Integer
   ) return Integer; --  glut.h:618
   pragma Import (Stdcall, glutBitmapWidth, "glutBitmapWidth");

   procedure glutStrokeCharacter(
      font : System.Address;
      character : Integer
   ); --  glut.h:619
   pragma Import (Stdcall, glutStrokeCharacter, "glutStrokeCharacter");

   function glutStrokeWidth(
      font : System.Address;
      character : Integer
   ) return Integer; --  glut.h:620
   pragma Import (Stdcall, glutStrokeWidth, "glutStrokeWidth");

   function glutBitmapLength(
      font : System.Address;
      the_string : Interfaces.C.Strings.Chars_Ptr
   ) return Integer; --  glut.h:622
   pragma Import (Stdcall, glutBitmapLength, "glutBitmapLength");

   function glutBitmapLength(
      font : System.Address;
      the_string : String
   ) return Integer; --  glut.h:622

   function glutStrokeLength(
      font : System.Address;
      the_string : Interfaces.C.Strings.Chars_Ptr
   ) return Integer; --  glut.h:623
   pragma Import (Stdcall, glutStrokeLength, "glutStrokeLength");

   function glutStrokeLength(
      font : System.Address;
      the_string : String
   ) return Integer; --  glut.h:623

   --  GLUT pre-built models sub-API 


   procedure glutWireSphere(
      radius : GL.GLdouble;
      slices : GL.GLint;
      stacks : GL.GLint
   ); --  glut.h:627
   pragma Import (Stdcall, glutWireSphere, "glutWireSphere");

   procedure glutSolidSphere(
      radius : GL.GLdouble;
      slices : GL.GLint;
      stacks : GL.GLint
   ); --  glut.h:628
   pragma Import (Stdcall, glutSolidSphere, "glutSolidSphere");

   procedure glutWireCone(
      base : GL.GLdouble;
      height : GL.GLdouble;
      slices : GL.GLint;
      stacks : GL.GLint
   ); --  glut.h:629
   pragma Import (Stdcall, glutWireCone, "glutWireCone");

   procedure glutSolidCone(
      base : GL.GLdouble;
      height : GL.GLdouble;
      slices : GL.GLint;
      stacks : GL.GLint
   ); --  glut.h:630
   pragma Import (Stdcall, glutSolidCone, "glutSolidCone");

   procedure glutWireCube(
      size : GL.GLdouble
   ); --  glut.h:631
   pragma Import (Stdcall, glutWireCube, "glutWireCube");

   procedure glutSolidCube(
      size : GL.GLdouble
   ); --  glut.h:632
   pragma Import (Stdcall, glutSolidCube, "glutSolidCube");

   procedure glutWireTorus(
      innerRadius : GL.GLdouble;
      outerRadius : GL.GLdouble;
      sides : GL.GLint;
      rings : GL.GLint
   ); --  glut.h:633
   pragma Import (Stdcall, glutWireTorus, "glutWireTorus");

   procedure glutSolidTorus(
      innerRadius : GL.GLdouble;
      outerRadius : GL.GLdouble;
      sides : GL.GLint;
      rings : GL.GLint
   ); --  glut.h:634
   pragma Import (Stdcall, glutSolidTorus, "glutSolidTorus");

   procedure glutWireDodecahedron; --  gl.h:635
   pragma Import (Stdcall, glutWireDodecahedron, "glutWireDodecahedron");

   procedure glutSolidDodecahedron; --  gl.h:636
   pragma Import (Stdcall, glutSolidDodecahedron, "glutSolidDodecahedron");

   procedure glutWireTeapot(
      size : GL.GLdouble
   ); --  glut.h:637
   pragma Import (Stdcall, glutWireTeapot, "glutWireTeapot");

   procedure glutSolidTeapot(
      size : GL.GLdouble
   ); --  glut.h:638
   pragma Import (Stdcall, glutSolidTeapot, "glutSolidTeapot");

   procedure glutWireOctahedron; --  gl.h:639
   pragma Import (Stdcall, glutWireOctahedron, "glutWireOctahedron");

   procedure glutSolidOctahedron; --  gl.h:640
   pragma Import (Stdcall, glutSolidOctahedron, "glutSolidOctahedron");

   procedure glutWireTetrahedron; --  gl.h:641
   pragma Import (Stdcall, glutWireTetrahedron, "glutWireTetrahedron");

   procedure glutSolidTetrahedron; --  gl.h:642
   pragma Import (Stdcall, glutSolidTetrahedron, "glutSolidTetrahedron");

   procedure glutWireIcosahedron; --  gl.h:643
   pragma Import (Stdcall, glutWireIcosahedron, "glutWireIcosahedron");

   procedure glutSolidIcosahedron; --  gl.h:644
   pragma Import (Stdcall, glutSolidIcosahedron, "glutSolidIcosahedron");

   --  GLUT video resize sub-API. 


   function glutVideoResizeGet(
      param : GL.GLenum
   ) return Integer; --  glut.h:648
   pragma Import (Stdcall, glutVideoResizeGet, "glutVideoResizeGet");

   procedure glutSetupVideoResizing; --  gl.h:649
   pragma Import (Stdcall, glutSetupVideoResizing, "glutSetupVideoResizing");

   procedure glutStopVideoResizing; --  gl.h:650
   pragma Import (Stdcall, glutStopVideoResizing, "glutStopVideoResizing");

   procedure glutVideoResize(
      x : Integer;
      y : Integer;
      width : Integer;
      height : Integer
   ); --  glut.h:651
   pragma Import (Stdcall, glutVideoResize, "glutVideoResize");

   procedure glutVideoPan(
      x : Integer;
      y : Integer;
      width : Integer;
      height : Integer
   ); --  glut.h:652
   pragma Import (Stdcall, glutVideoPan, "glutVideoPan");

   --  GLUT debugging sub-API. 


   procedure glutReportErrors; --  gl.h:655
   pragma Import (Stdcall, glutReportErrors, "glutReportErrors");

   --  GLUT device control sub-API. 

   --  glutSetKeyRepeat modes. 

   GLUT_KEY_REPEAT_OFF                  : constant := 0; --  glut.h:661
   GLUT_KEY_REPEAT_ON                   : constant := 1; --  glut.h:662
   GLUT_KEY_REPEAT_DEFAULT              : constant := 2; --  glut.h:663

   --  Joystick button masks. 

   GLUT_JOYSTICK_BUTTON_A               : constant := 1; --  glut.h:666
   GLUT_JOYSTICK_BUTTON_B               : constant := 2; --  glut.h:667
   GLUT_JOYSTICK_BUTTON_C               : constant := 4; --  glut.h:668
   GLUT_JOYSTICK_BUTTON_D               : constant := 8; --  glut.h:669


   procedure glutIgnoreKeyRepeat(
      ignore : Integer
   ); --  glut.h:671
   pragma Import (Stdcall, glutIgnoreKeyRepeat, "glutIgnoreKeyRepeat");

   procedure glutSetKeyRepeat(
      repeatMode : Integer
   ); --  glut.h:672
   pragma Import (Stdcall, glutSetKeyRepeat, "glutSetKeyRepeat");

   procedure glutForceJoystickFunc; --  gl.h:673
   pragma Import (Stdcall, glutForceJoystickFunc, "glutForceJoystickFunc");

   --  GLUT game mode sub-API. 

   --  glutGameModeGet. 

   GLUT_GAME_MODE_ACTIVE                : constant := 0; --  glut.h:677
   GLUT_GAME_MODE_POSSIBLE              : constant := 1; --  glut.h:678
   GLUT_GAME_MODE_WIDTH                 : constant := 2; --  glut.h:679
   GLUT_GAME_MODE_HEIGHT                : constant := 3; --  glut.h:680
   GLUT_GAME_MODE_PIXEL_DEPTH           : constant := 4; --  glut.h:681
   GLUT_GAME_MODE_REFRESH_RATE          : constant := 5; --  glut.h:682
   GLUT_GAME_MODE_DISPLAY_CHANGED       : constant := 6; --  glut.h:683


   procedure glutGameModeString(
      the_string : Interfaces.C.Strings.Chars_Ptr
   ); --  glut.h:685
   pragma Import (Stdcall, glutGameModeString, "glutGameModeString");

   procedure glutGameModeString(
      the_string : String
   ); --  glut.h:685
   function glutEnterGameMode return Integer; --  gl.h:686
   pragma Import (Stdcall, glutEnterGameMode, "glutEnterGameMode");

   procedure glutLeaveGameMode; --  gl.h:687
   pragma Import (Stdcall, glutLeaveGameMode, "glutLeaveGameMode");

   function glutGameModeGet(
      mode : GL.GLenum
   ) return Integer; --  glut.h:688
   pragma Import (Stdcall, glutGameModeGet, "glutGameModeGet");






end Win32.Glut;
